--安检情况汇总
--分组项：f_plan_month计划月份，f_no_checkplan计划类型，f_residential_area小区，f_plan_name计划名称
--        f_checker_name安检员
--求和项：f_user_number档案数，f_plan_total计划总数，f_weijian未检计划数，f_yijian已检计划数
--        f_ruhu入户数，f_buyu到访不遇数，f_jujian拒检数，安检率
SELECT COUNT
		   ( * ) f_plan_total,
	   SUM ( f_weijian ) f_weijian,
	   SUM ( f_yijian ) f_yijian,
	   SUM ( f_ruhu ) f_ruhu,
	   SUM ( f_buyu ) f_buyu,
	   SUM ( f_jujian ) f_jujian,
	   SUM ( f_defectsum ) f_defectsum,
	   CAST (
			   CONVERT (
					   DECIMAL ( 18, 2 ),
					   CASE
						   WHEN COUNT ( * ) = 0 THEN
							   0.00 ELSE SUM ( f_yijian ) / ( COUNT ( * ) + 0.00 ) * 100.00
						   END
				   ) AS VARCHAR
		   ) + '%' f_check_bv,
	   CAST (
			   CONVERT (
					   DECIMAL ( 18, 2 ),
					   CASE
						   WHEN COUNT ( * ) = 0 THEN
							   0.00 ELSE SUM ( f_ruhu ) / ( COUNT ( * ) + 0.00 ) * 100.00
						   END
				   ) AS VARCHAR
		   ) + '%' f_ruhu_bv,
	{ groupName }
FROM
	(
		SELECT
			cpi.f_no_checkplan,
			cpi.f_residential_area,
			ta.f_slice_area,
			cpi.f_plan_id,
			cpl.f_plan_name,
			cpall.f_offsite_time,
			cpall.f_check_type,
			cpi.f_filialeid,
			cpl.f_plan_year AS f_year,
			cpl.f_plan_month AS f_month,
			CAST ( cpl.f_plan_year AS VARCHAR ) + '年' + CAST ( cpl.f_plan_month AS VARCHAR ) + '月' f_plan_month,
			CASE
			WHEN cpall.f_checker_name IS NULL THEN
			cpl.f_checker ELSE cpall.f_checker_name
			END f_checker_name,
			CASE
			WHEN cpi.f_state= '未检' THEN
			1 ELSE 0
			END f_weijian,
			CASE
			WHEN cpi.f_state= '已检' THEN
			1 ELSE 0
			END f_yijian,
			CASE
			WHEN f_entry_status = '入户' THEN
			1 ELSE 0
			END f_ruhu,
			CASE
			WHEN f_entry_status = '到访不遇' THEN
			1 ELSE 0
			END f_buyu,
			CASE
			WHEN f_entry_status = '拒检' THEN
			1 ELSE 0
			END f_jujian,
			CASE
			WHEN f_defect_content LIKE '%有隐患%'
			AND f_entry_status = '入户' THEN
			1 ELSE 0
			END f_defectsum
		FROM
			t_check_plan_item cpi
			LEFT JOIN t_check_plan cpl ON cpi.f_plan_id = cpl.id
			left join t_user_address tua on tua.f_userinfo_id = cpi.f_userinfoid
			left join t_area ta on tua.f_residential_area_id = ta.id
			LEFT JOIN ( SELECT f_check_item_id, MAX ( f_offsite_time ) f_offsite_time FROM t_check_paper GROUP BY f_check_item_id ) cp ON cpi.id= cp.f_check_item_id
			LEFT JOIN t_check_paper cpall ON cp.f_check_item_id = cpall.f_check_item_id AND cp.f_offsite_time = cpall.f_offsite_time
		WHERE
			cpi.f_state!= '作废'
	) ch
	LEFT JOIN (
		SELECT
			ua.f_residential_area area,
			COUNT ( * ) f_user_number
		FROM
			t_user_address ua
			LEFT JOIN t_userinfo u ON ua.f_userinfo_id= u.f_userinfo_id
		WHERE
			f_user_state = '正常'
		GROUP BY
			ua.f_residential_area
	) u ON ch.f_residential_area = u.area
WHERE
	{ condition }
GROUP BY
	{ groupName }
HAVING 1=1
	{f_check_bv_start == null:$$, $and CASE WHEN COUNT ( * ) = 0 THEN 0.00 ELSE SUM ( f_yijian ) / ( COUNT ( * ) + 0.00 ) * 100.00 END >= {f_check_bv_start} * 1.00$}
	{f_check_bv_end == null:$$, $and CASE WHEN COUNT ( * ) = 0 THEN 0.00 ELSE SUM ( f_yijian ) / ( COUNT ( * ) + 0.00 ) * 100.00 END <= {f_check_bv_end} * 1.00$}
	{f_ruhu_bv_start == null:$$, $and CASE WHEN COUNT ( * ) = 0 THEN 0.00 ELSE SUM ( f_ruhu ) / ( COUNT ( * ) + 0.00 ) * 100.00 END >= {f_ruhu_bv_start} * 1.00$}
	{f_ruhu_bv_end == null:$$, $and CASE WHEN COUNT ( * ) = 0 THEN 0.00 ELSE SUM ( f_ruhu ) / ( COUNT ( * ) + 0.00 ) * 100.00 END <= {f_ruhu_bv_end} * 1.00$}
ORDER BY
	{ groupName }
