SELECT
    *
FROM
    (
        SELECT
            tcp.*,
            f_meter_book_num,
            tus.f_department_name,
            tud.f_slice_area,
            tud.f_pcd,
            f_aroundmeter,
            f_position,
            f_metertitles,
            tui.f_user_state,
            --tbb.f_gasproperties,
            tbb.f_meter_classify,
            case WHEN tcp.f_check_plan_id is null then '无计划安检' else cp.f_plan_name end as f_plan_name,--计划名称
            --tg.f_meter_type, --气表类型
            --gm.f_meter_style,--表品牌&表型号
            --tg.f_collection_type, --用气性质
            --tg.f_meter_brand, --气表品牌
            --tbb.f_meternumber, --表号
            --tbb.f_defendcard, --防盗卡号1
            --tbb.f_defendcard_two, --防盗卡号2
            tcp2.f_total_fee f_total_fee,--累购金额
            tcp2.f_total_gas f_total_gas,--累购气量
            tcp2.f_residue_fee f_residue_fee,--剩余金额
            tcp2.f_difference_gas f_difference_gas,--气量异常差值
            tcp2.f_difference_fee f_difference_fee,--金额异常差值
            tcp2.f_used_gas f_used_gas,--已用气量
            tcp2.f_used_fee f_used_fee,--已用金额
            tcp2.f_residue_gas f_residue_gas,--剩余气量
            tcp2.f_base_num_system f_base_num_system,--系统表底数
            tcp2.f_base_num_machinery f_base_num_machinery--机械表读数
        FROM
            (
                SELECT
                    id,
                    f_check_item_id,
                    f_check_plan_id,
                    f_checker_id,
                    f_complete,
                    f_userinfo_code,
                    f_prearranged_date,
                    f_no_checkplan,
                    f_checker_name,
                    f_entry_status,
                    f_usegas,
                    f_state,
                    f_upload_state,
                    f_nongasuser_path,
                    f_noanswer_path,
                    f_rejectcheck_path,
                    f_no_gas_device,
                    f_check_type,
                    f_noncivil_style,
                    f_stop_service,
                    f_usage,
                    f_signname,
                    f_sign_imgid,
                    f_sign_path,
                    f_subcompany,
                    f_user_name,
                    f_user_phone,
                    f_userinfoid,
                    f_card_id,
                    f_area,
                    f_street,
                    f_residential_area,
                    f_building,
                    f_unit,
                    f_floor,
                    f_room,
                    f_address,
                    f_room_style,
                    f_heating_style,
                    f_heating_style_,
                    f_recording1_path,
                    f_recording2_path,
                    f_recording3_path,
                    f_pic1_path,
                    f_pic2_path,
                    f_pic3_path,
                    f_defect_dorm,
                    f_defect_expand,
                    f_defect_other,
                    f_defect_notfixed,
                    f_notfixed_path,
                    f_close_valve,
                    f_close_valve_path,
                    f_unload_battery,
                    f_stop_devices,
                    f_zero_meter,
                    f_cutoff_gas,
                    f_cutoff_gas_path,
                    f_empty_pipe,
                    f_close_adjuster,
                    f_close_adjuster_path,
                    f_defect_notified,
                    f_notified_path,
                    f_defect_registered,
                    f_overall2_path,
                    f_client_suggestion,
                    f_client_evaluation,
                    f_repairman,
                    f_defect_urgency,
                    f_repaired,
                    f_ratification_des,
                    f_repaired_uploaded,
                    f_repair_date,
                    f_amr_path,
                    f_longitude,
                    f_latitude,
                    f_remark,
                    f_approved,
                    f_approved_time,
                    f_approved_by,
                    f_approved_note,
                    f_repair_approved,
                    f_repair_approved_time,
                    f_repair_approved_by,
                    f_repair_approved_note,
                    f_SafeToRepair_id,
                    f_defect_content,
                    f_orgstr,
                    f_filialeids,
                    f_filialeid,
                    f_idnumber,
                    f_plan_id,
                    f_comments,
                    f_userproperties,
                    f_user_inhome_time,
                    f_user_check_time,
                    f_user_spare_phone,
                    f_user_family_remarks,
                    f_user_equipment_remarks,
                    f_danger_state,
                    f_read_instructions,
                    f_blacklist,
                    f_supplement_tag,
                    f_safecheck_type,
                    f_exceed_reason,
                    f_is_meterreadding,
                    f_blocking_cause,
                    f_send_message,
                    f_laser_check,
                    f_offsite_time,
                    f_onsite_time,
                    f_upload_date,
                    f_defendcard,
                    f_defendcard_two,
                    f_meternumber,
					f_collection_type,
                    f_meter_type,
                    f_meter_style,
                    f_gasproperties,
                    f_meter_classify as f_meter_brand,
                    case when f_check_version = 0 then null else f_check_version end f_check_version
                FROM
                    t_check_paper  WITH ( nolock )
                where 1=1
                    { f_entry_status != $$ && f_entry_status != null:$and f_entry_status = '{f_entry_status}'$,$$ }
                    { f_filialeid == $$ : $$ , $ and f_filialeid in {f_filialeid} $ }
                    { f_check_start != $$ && f_check_start != null : $ and f_offsite_time >= '{f_check_start} 00:00:00' $,$$ }
                    { f_check_end != $$ && f_check_end != null : $ and f_offsite_time <= '{f_check_end} 23:59:59' $,$$ }
            ) tcp
                LEFT JOIN t_user tus on tus.id=tcp.f_checker_id
                LEFT JOIN t_userfiles tbb ON tcp.f_userinfoid= tbb.f_userinfo_id and tbb.f_table_state = '正常'
                left join t_gasbrand tg on tbb.f_gasbrand_id = tg.id
                LEFT JOIN t_userinfo tui ON tcp.f_userinfoid = tui.f_userinfo_id
                LEFT JOIN t_user_address tud  WITH ( nolock )  ON tcp.f_userinfoid= tud.f_userinfo_id
            left join t_check_plan cp on tcp.f_check_plan_id = cp.id
            LEFT JOIN t_gasmodel gm on tbb.f_gasmodel_id = gm.id
            left join (SELECT
                            tcp.id,
                            max(isnull(CASE WHEN tdi.f_item_name = '累购金额' THEN tdil.f_item_value ELSE NULL END, 0.0)) AS f_total_fee,
                            max(isnull(CASE WHEN tdi.f_item_name = '累购气量' THEN tdil.f_item_value ELSE NULL END, 0.0)) AS f_total_gas,
                            max(isnull(CASE WHEN tdi.f_item_name = '剩余金额' THEN tdil.f_item_value ELSE NULL END, 0.0)) AS f_residue_fee,
                            max(isnull(CASE WHEN tdi.f_item_name = '气量异常差值' THEN tdil.f_item_value ELSE NULL END, 0.0)) AS f_difference_gas,
                            max(isnull(CASE WHEN tdi.f_item_name = '金额异常差值' THEN tdil.f_item_value ELSE NULL END, 0.0)) AS f_difference_fee,
                            max(isnull(CASE WHEN tdi.f_item_name = '已用气量' THEN tdil.f_item_value ELSE NULL END, 0.0)) AS f_used_gas,
                            max(isnull(CASE WHEN tdi.f_item_name = '已用金额' THEN tdil.f_item_value ELSE NULL END, 0.0)) AS f_used_fee,
                            max(isnull(CASE WHEN tdi.f_item_name = '剩余气量' THEN tdil.f_item_value ELSE NULL END, 0.0)) AS f_residue_gas,
                            max(isnull(CASE WHEN tdi.f_item_name = '系统表底数' THEN tdil.f_item_value ELSE NULL END, 0.0)) AS f_base_num_system,
                            max(isnull(CASE WHEN tdi.f_item_name = '机械表读数' THEN tdil.f_item_value ELSE NULL END, 0.0)) AS f_base_num_machinery
                        FROM
                            t_check_paper tcp
                            LEFT JOIN t_paper_devices tpd ON tcp.id = tpd.f_paper_id
                            LEFT JOIN t_devices_items tdi ON tdi.f_device_id = tpd.id
                            LEFT JOIN t_devices_items_lists tdil ON tdil.f_item_id = tdi.id
                        where 1=1
                            { f_filialeid == $$ : $$ , $ and f_filialeid in {f_filialeid} $ }
                            { f_check_start != $$ && f_check_start != null : $ and f_offsite_time >= '{f_check_start} 00:00:00' $,$$ }
                            { f_check_end != $$ && f_check_end != null : $ and f_offsite_time <= '{f_check_end} 23:59:59' $,$$ }
                        GROUP BY
                            tcp.id
                    ) tcp2 on tcp2.id = tcp.id
    ) tt
WHERE
    { condition }
    {
    f_plan_id == $$ :
    $$
    , $
  and f_check_plan_id = '{f_plan_id}'
    $
    }
    {
    f_approved == $$ :
    $$
    , $
  and f_approved = '{f_approved}'
    $
    }
    {
    f_entry_status == $$ :
    $$
    , $
  and f_entry_status = '{f_entry_status}'
    $
    }
    {
    f_no_checkplan == $$ :
    $$
    , $
  and f_no_checkplan = '{f_no_checkplan}'
    $
    }
    {
    f_filialeid == $$ :
    $$
    , $
  and f_filialeid in {f_filialeid}
    $
    }
Order by
    f_offsite_time desc
