SELECT
    *
FROM (
         SELECT
             t_temp.*,
             (
                 CASE f_defect_count
                     WHEN 0
                         THEN '无隐患'
                     ELSE '有隐患'
                     END
                 ) f_has_defect,
             (
                 CASE WHEN f_repair_count=f_defect_count
                          THEN '已完成'
                      ELSE '未完成'
                     END
                 ) f_is_repair,
             (
                 CASE WHEN f_deal_count=f_defect_count
                          THEN '已处理'
                      ELSE '未处理'
                     END
                 ) f_is_deal
         FROM (
                  SELECT
                      cp.id,
                      cp.f_repair_date,
                      cp.f_entry_status,
                      cp.f_residential_area,
                      cp.f_building,
                      cp.f_floor,
                      cp.f_room,
                      cp.f_street,
                      cp.f_unit,
                      cp.f_defect_text,
                      cp.f_check_type,
                      cp.f_userinfoid,
                      cp.f_user_phone,
                      ui.f_zuhu_phone,
                      ui.f_rent_phone,
                      ui.f_uservent_date,
                      cp.f_userinfo_code,
                      cp.f_user_name,
                      cp.f_onsite_time,
                      cp.f_offsite_time,
                      cp.f_checker_name,
                      cp.f_repaired,
                      ua.f_address,
                      tu.f_meter_book_num,
                      ua.f_slice_area,
                      cp.f_check_plan_id,
                      cpl.f_plan_name,
                      ui.f_userinfo_id,
                      ui.f_filialeid,
                      ui.f_user_nature,
                      f_defect_content,
                      {f_defect_content} defecttext,
                      pd1.*
                  FROM
                      t_check_paper cp
                      LEFT JOIN t_check_plan cpl ON cpl.id = cp.f_check_plan_id
                      LEFT JOIN t_userinfo ui ON ui.f_userinfo_id = cp.f_userinfoid
                      left join (select * from t_userfiles where f_table_state = '正常' or f_table_state = '停用') tu on cp.f_userinfoid=tu.f_userinfo_id
                      LEFT JOIN t_user_address ua ON ua.f_userinfo_id = cp.f_userinfoid
                      LEFT JOIN (
                      SELECT
                      pd.f_paper_id,
                      ISNULL(
                      SUM(
                      CASE di.f_is_defect
                      WHEN 'true'
                      THEN 1
                      ELSE 0
                      END
                      ),0) f_defect_count,
                      ISNULL(
                      SUM(
                      CASE
                      WHEN di.f_live_dispose='是' or di.f_is_repaired in('已处理')
                      or f_deal_dispose in('现场整改','自行整改', '自行处理')
                      THEN 1
                      ELSE 0
                      END
                      ),0) f_repair_count,
                      ISNULL(
                      SUM(
                      CASE
                      WHEN di.f_live_dispose='是' or di.f_is_repaired in('已处理','转维修')
                      or f_deal_dispose in('现场整改','自行整改', '自行处理')
                      THEN 1
                      ELSE 0
                      END
                      ),0) f_deal_count,
                      max(f_repairman) f_repairman,
                      ISNULL(
                      SUM(
                      CASE
                      WHEN di.f_is_defect = 'true' and di.f_defect_level='一级隐患'
                      THEN 1
                      ELSE 0
                      END
                      ),0) f_fist_count,
                      ISNULL(
                      SUM(
                      CASE
                      WHEN di.f_is_defect = 'true' and di.f_defect_level='二级隐患'
                      THEN 1
                      ELSE 0
                      END
                      ),0) f_second_count,
                      ISNULL(
                      SUM(
                      CASE
                      WHEN di.f_is_defect = 'true' and di.f_defect_level='三级隐患'
                      THEN 1
                      ELSE 0
                      END
                      ),0) f_third_count,
                      ISNULL(
                      SUM(
                      CASE
                      WHEN di.f_user_changes='是'
                      or di.f_deal_dispose in('自行整改', '自行处理')
                      THEN 1
                      ELSE 0
                      END
                      ),0) zxzg_count
                      FROM
                      t_paper_devices pd WITH(NOLOCK)
                      LEFT JOIN t_devices_items di WITH(NOLOCK) ON di.f_is_defect = 'true' and di.f_device_id = pd.id
                      group by f_paper_id
                      ) pd1 on pd1.f_paper_id=cp.id
                  WHERE
                      ui.f_user_state  = '正常' and cp.f_entry_status='入户'
                    AND ui.f_filialeid in {f_filialeids}
              ) t_temp
     ) t_temp2
WHERE
    {condition}
ORDER BY
    f_offsite_time
