SELECT
    *
FROM
    (
        SELECT
            pd.f_paper_id,
            pd.f_device_type,
            di.id,
            di.f_item_name,
            di.f_path,
            di.f_repair_path,
            di.f_repairman,
            di.f_repair_date,
            dil.f_item_value,
            CASE

                WHEN di.f_is_defect != 'true' THEN
                    '无隐患'
                WHEN di.f_is_defect = 'true'
                    AND di.f_user_changes = '是' THEN
                    '用户自行整改'
                WHEN di.f_is_defect = 'true'
                    AND di.f_live_dispose = '是' THEN
                    '现场已处理'
                WHEN di.f_is_defect = 'true'
                    AND di.f_is_repaired = '已处理' THEN
                    '维修已处理'
                WHEN di.f_is_defect = 'true'
                    AND di.f_is_repaired = '转维修' THEN
                    '转维修' ELSE '隐患未处理'
                END f_repaire_type,
            CASE

                WHEN di.f_is_defect != 'true' THEN
                    1
                WHEN di.f_is_defect = 'true'
                    AND di.f_user_changes = '是' THEN
                    2
                WHEN di.f_is_defect = 'true'
                    AND di.f_live_dispose = '是' THEN
                    3
                WHEN di.f_is_defect = 'true'
                    AND di.f_is_repaired = '已处理' THEN
                    4
                WHEN di.f_is_defect = 'true'
                    AND di.f_is_repaired = '转维修' THEN
                    5 ELSE 10
                END f_danger_leave
        FROM
            t_paper_devices pd { entity.findDialect ( ) == $SqlServer$:$ WITH ( nolock ) $, $ $}
            LEFT JOIN t_devices_items di { entity.findDialect ( ) == $SqlServer$:$ WITH ( nolock ) $, $ $} ON di.f_device_id = pd.id
            LEFT JOIN t_devices_items_lists dil { entity.findDialect ( ) == $SqlServer$:$ WITH ( nolock ) $, $ $} ON dil.f_item_id= di.id
        WHERE
            pd.f_paper_id in (
            SELECT
            id
            FROM (
            SELECT
            t_temp.*,f_meter_book_num,f_slice_area,
            (
            CASE f_defect_count
            WHEN 0
            THEN '无隐患'
            ELSE '有隐患'
            END
            ) f_has_defect,
            (
            CASE WHEN f_repair_count=f_defect_count
            THEN '已完成'
            ELSE '未完成'
            END
            ) f_is_repair,
            (
            CASE WHEN f_deal_count=f_defect_count
            THEN '已处理'
            ELSE '未处理'
            END
            ) f_is_deal
            FROM (
            SELECT
            cp.id,
            cp.f_entry_status,
            cp.f_residential_area,
            cp.f_user_phone,
            cp.f_userinfo_code,
            cp.f_user_name,
            cp.f_onsite_time,
            cp.f_offsite_time,
            cp.f_checker_name,
            cp.f_repaired,
            ua.f_address,
            cp.f_check_plan_id,
            cpl.f_plan_name,
            ui.f_userinfo_id,
            ui.f_filialeid,
            {f_defect_content} f_defect_content,
            (
            SELECT
            SUM(
            CASE di.f_is_defect
            WHEN 'true'
            THEN 1
            ELSE 0
            END
            ) f_defect_count
            FROM
            t_paper_devices pd
            LEFT JOIN t_devices_items di ON di.f_device_id = pd.id
            WHERE
            pd.f_paper_id = cp.id
            )
            f_defect_count,
            (
            SELECT
            SUM(
            CASE
            WHEN di.f_live_dispose='是' or di.f_is_repaired='已处理' THEN 1

            ELSE 0
            END
            ) f_repair_count
            FROM
            t_paper_devices pd
            LEFT JOIN t_devices_items di ON di.f_device_id = pd.id

            WHERE
            pd.f_paper_id = cp.id
            )
            f_repair_count,
            (
            SELECT
            SUM(
            CASE
            WHEN (di.f_live_dispose='是' or di.f_is_repaired is not null) and di.f_is_defect='true' THEN 1

            ELSE 0
            END
            ) f_repair_count
            FROM
            t_paper_devices pd
            LEFT JOIN t_devices_items di ON di.f_device_id = pd.id

            WHERE
            pd.f_paper_id = cp.id
            )
            f_deal_count,
            (
            SELECT
            max(f_repairman) f_repairman
            FROM
            t_paper_devices pd
            LEFT JOIN t_devices_items di ON di.f_device_id = pd.id

            WHERE
            pd.f_paper_id = cp.id
            )
            f_repairman
            FROM
            t_check_paper cp
            LEFT JOIN t_check_plan cpl ON cpl.id = cp.f_check_plan_id
            LEFT JOIN t_userinfo ui ON ui.f_userinfo_id = cp.f_userinfoid
            LEFT JOIN t_user_address ua ON ua.f_userinfo_id = cp.f_userinfoid
            WHERE
            ui.f_user_state  = '正常'
          AND ui.f_filialeid in {f_filialeids}
            ) t_temp
            left join t_userfiles tu on t_temp.f_userinfo_id=tu.f_userinfo_id
            left join t_user_address tud on t_temp.f_userinfo_id=tud.f_userinfo_id
            ) t_temp2
            WHERE
            {condition} AND f_filialeid in {f_filialeids}
            )
    ) t_temp
WHERE
    f_repaire_type != '无隐患'
ORDER BY
    f_danger_leave DESC