SELECT
    f_checker,
    f_checker_id,
    sum( plannum ) plannum,
    sum( no_plan_num ) no_plan_num,
    sum( wrj ) wrj,
    sum( yrj ) yrj,
    sum( ruhu ) ruhu,
    sum( daofang ) daofang,
    sum( jujian ) jujian,
    sum( noruhu ) noruhu,
    sum( nodaofang ) nodaofang,
    sum( nojujian ) nojujian,
    (sum(ruhu) + sum(noruhu))  ruhu_total,
    (sum(daofang) + sum(nodaofang))  daofang_total,
    (sum(jujian) + sum(nojujian))  jujian_total,
    ((sum(ruhu) + sum(noruhu)) + (sum(daofang) + sum(nodaofang)) + (sum(jujian) + sum(nojujian))) AS total_sum,
    CASE
        WHEN ((sum(ruhu) + sum(noruhu)) + (sum(daofang) + sum(nodaofang)) + (sum(jujian) + sum(nojujian))) = 0 THEN 0.00
        ELSE CONVERT(decimal(18,2), (100.00 * (sum(ruhu) + sum(noruhu)) / ((sum(ruhu) + sum(noruhu)) + (sum(daofang) + sum(nodaofang)) + (sum(jujian) + sum(nojujian)))))
        END AS rhl,
    sum(wx_num) as wx_num,
    sum(repair_num) as repair_num,
    sum(defect_num) as defect_num,
    sum(zx_num) as zx_num,
    CASE
        WHEN sum(repair_num) = 0 THEN 0.00
        ELSE CONVERT(decimal(18,2), (100.00 * sum(wx_num) / sum(repair_num)))
        END AS wxl,
    CASE
        WHEN sum(defect_num) = 0 THEN 0.00
        ELSE CONVERT(decimal(18,2), (100.00 * (sum(zx_num)+sum(wx_num)) / sum(defect_num)))
        END AS cll
FROM
    (
        SELECT
            f_checker,
            f_checker_id,
            COUNT( 1 ) AS plannum,
            SUM(
                    isnull( wrj, 0 )) AS wrj,
            SUM(
                    isnull( yrj, 0 )) AS yrj,
            SUM(
                    isnull( ruhu, 0 )) AS ruhu,
            SUM(
                    isnull( daofang, 0 )) AS daofang,
            SUM(
                    isnull( jujian, 0 )) AS jujian,
            0 AS no_plan_num,
            0 AS noruhu,
            0 AS nodaofang,
            0 AS nojujian,
            0 as wx_num,
            0 as repair_num,
            0 as defect_num,
            0 as zx_num
        FROM
            (
                SELECT
                    isnull( tcp.f_checker, tt.f_checker_name ) AS f_checker,
                    isnull( tcp.f_checker_id, tt.f_checker_id ) AS f_checker_id,
                    CASE
                        WHEN tcpi.f_state = '未检'
                            OR ( tcpi.f_state = '已检' AND tcpi.F_LAST_CHECK_STATE != '入户' ) THEN
                            1 ELSE 0
                        END AS wrj,
                    CASE
                        WHEN tcpi.f_state = '已检'
                            AND tcpi.F_LAST_CHECK_STATE = '入户' THEN
                            1 ELSE 0
                        END AS yrj,
                    ruhu,
                    daofang,
                    jujian
                FROM
                    (
                        SELECT
                            *
                        FROM
                            t_check_plan
                        WHERE
                            f_filialeid IN { f_filialeids }
                    ) tcp
                        LEFT JOIN ( SELECT * FROM t_check_plan_item WHERE f_filialeid IN { f_filialeids } ) tcpi ON tcp.id = tcpi.f_plan_id
                        LEFT JOIN (
                        SELECT
                            a.*,
                            CASE
                                WHEN f_entry_status = '入户'
                                    THEN
                                    1 ELSE 0
                                END AS ruhu,
                            CASE
                                WHEN f_entry_status = '到访不遇'
                                    THEN
                                    1 ELSE 0
                                END AS daofang,
                            CASE
                                WHEN f_entry_status = '拒检'
                                    THEN
                                    1 ELSE 0
                                END AS jujian
                        FROM
                            t_check_paper a
                                INNER JOIN ( SELECT f_check_item_id, max( f_upload_date ) upload_time FROM t_check_paper GROUP BY f_check_item_id ) b ON a.f_check_item_id = b.f_check_item_id
                                AND b.upload_time = a.f_upload_date
                        WHERE
                            f_filialeid IN { f_filialeids } AND F_NO_CHECKPLAN = '有计划安检' { f_start_time == $$ : $$, $ AND f_offsite_time >= '{f_start_time} 00:00:00' $ } { f_end_time == $$ : $$, $ AND f_offsite_time <= '{f_end_time} 23:59:59' $ }
                    ) tt ON tt.f_check_item_id = tcpi.id
                WHERE
                        1 = 1
                  AND { condition1 }
            ) paper
        WHERE
            f_checker IS NOT NULL { condition3 }
        GROUP BY
            f_checker_id,
            f_checker
        UNION ALL
        SELECT
            f_checker,
            f_checker_id,
            0 AS plannum,
            0 AS wrj,
            0 AS yrj,
            0 AS ruhu,
            0 AS daofang,
            0 AS jujian,
            count( t.f_check_item_id ) AS no_plan_num,
            sum( case when rh > 0 then 1 else 0 end ) AS noruhu,
            sum( case when df > 0 and rh = 0 and jj = 0 then 1 else 0 end ) AS nodaofang,
            sum( case when jj > 0 and rh = 0 and df = 0 then 1 else 0 end ) AS nojujian,
            0 as wx_num,
            0 as repair_num,
            0 as defect_num,
            0 as zx_num
        FROM
            (
            SELECT
            f_checker_id,
            f_check_item_id,
            f_checker_name AS f_checker,
            sum( CASE WHEN f_entry_status = '入户' THEN 1 ELSE 0 END ) AS rh,
            sum( CASE WHEN f_entry_status = '到访不遇' THEN 1 ELSE 0 END ) AS df,
            sum( CASE WHEN f_entry_status = '拒检' THEN 1 ELSE 0 END ) AS jj
            FROM
            t_check_paper
            WHERE
            f_no_checkplan = '无计划安检'
            AND f_filialeid IN { f_filialeids }
            AND { condition2 }
            GROUP BY
            f_check_item_id,
            f_checker_id,
            f_checker_name
            ) t
        GROUP BY
            f_checker_id,
            f_checker
        UNION ALL
        SELECT
            f_checker,
            f_checker_id,
            0 AS plannum,
            0 AS wrj,
            0 AS yrj,
            0 AS ruhu,
            0 AS daofang,
            0 AS jujian,
            0 AS no_plan_num,
            0 AS noruhu,
            0 AS nodaofang,
            0 AS nojujian,
            sum(wx_num) wx_num,
            sum(repair_num) repair_num,
            0 as defect_num,
            0 as zx_num
        FROM
            (
                SELECT
                    f_checker_name as f_checker,
                    f_checker_id,
                    count(act.id) as wx_num,
                    count(tswo.id) as repair_num
                FROM
                    t_check_paper tcp
                    left join t_serviceworkorder tswo on tcp.f_SafeToRepair_id = tswo.f_service_id
                    left join activityins act on tswo.f_processid = act.processid and act.defname = '维修完成' and act.state = '开始活动'
                WHERE
                    1=1 AND { condition2 }
                GROUP BY
                    f_checker_name,
                    f_checker_id
            ) t
        GROUP BY
            f_checker_id,
            f_checker
        UNION ALL
        SELECT
            f_checker,
            f_checker_id,
            0 AS plannum,
            0 AS wrj,
            0 AS yrj,
            0 AS ruhu,
            0 AS daofang,
            0 AS jujian,
            0 AS no_plan_num,
            0 AS noruhu,
            0 AS nodaofang,
            0 AS nojujian,
            0 as wx_num,
            0 as repair_num,
            sum(defect_num) as defect_num,
            sum(zx_num) as zx_num
        FROM
            (
                select
                    f_checker_name as f_checker,
                    f_checker_id,
                    sum(case when di.id is not null then 1 else 0 end) as zx_num,
                    count(0) as defect_num
                from t_check_paper tcp
                    left join t_paper_devices pd on pd.f_paper_id = tcp.id
                    left join t_devices_items di on pd.id=di.f_device_id and f_deal_dispose = '自行处理'
                where f_defect_content like '%有隐患%' AND { condition2 }
                group by f_checker_name,f_checker_id
            ) t
        GROUP BY
            f_checker_id,
            f_checker
    ) c
GROUP BY
    f_checker,
    f_checker_id
ORDER BY
    f_checker_id
