SELECT
    isnull(cpp.f_checker_name,'') f_checker_name,
    case when di.f_defect_level is null or di.f_defect_level = '' then '无等级' else di.f_defect_level end f_defect_level,
    cpd.f_device_type
FROM
    t_check_plan_item cpi
        LEFT JOIN t_check_plan cpl ON cpl.id = cpi.f_plan_id
        LEFT JOIN t_check_paper cpp ON cpi.id = cpp.f_check_item_id
        LEFT JOIN t_paper_devices cpd ON cpd.f_paper_id = cpp.id
        LEFT JOIN t_devices_items di ON cpd.id = di.f_device_id
where di.f_is_defect = 'true' AND CPP.f_checker_name IS NOT NULL and {condition}
  and cpp.f_upload_date >= '{plan_date_start} 00:00:00'
  and  cpp.f_upload_date <= '{plan_date_end} 23:59:59'
    {
    f_filialeid!=$$:
    $ and cpp.f_filialeid in {f_filialeid}$,
    $$
    }
GROUP BY
    cpp.f_checker_name,
    di.f_defect_level,
    cpd.f_device_type
having count(*) > 0
order by  cpp.f_checker_name desc
