SELECT
    CONCAT ( f_plan_year, '-', f_plan_month ) AS f_left_name1,--计划月份
    CASE WHEN f_checker IS NULL THEN '共享计划' ELSE f_checker END AS f_left_name2,--安检员
    COUNT ( 0 ) AS f_data1,--计划总数
    SUM ( CASE WHEN f_defect_content LIKE '%正常%' THEN 0 ELSE 1 END ) AS f_data2,--隐患户数
    CONCAT ( SUM ( CASE WHEN cpi.f_state = '已检' THEN 1 ELSE 0 END ) * 100 / COUNT ( 0 ), '%' ) AS f_data3 --安检率
FROM
    t_check_plan cp
        LEFT JOIN t_check_plan_item cpi ON cp.id = cpi.f_plan_id
        LEFT JOIN t_check_paper tcp ON cpi.id = tcp.f_check_item_id
WHERE
    f_plan_month IS NOT NULL and {condition }
GROUP BY
    f_plan_year,
    f_plan_month,
    f_plan_name,
    f_checker
ORDER BY
    f_plan_year,
    f_plan_month