SELECT
    isnull(f_residential_area,'未定义') as area,
    isnull(f_checker,'未定义') as checker,
    isnull(COUNT(0),0) AS data1,
    isnull(SUM(CASE WHEN tcpi.f_state = '未检' THEN 1 ELSE 0 END),0) AS data2,
    isnull(SUM(CASE WHEN tcpi.f_last_check_state = '入户' OR tcpi.f_check_version >= 3 THEN 1 ELSE 0 END),0) AS data3,
    isnull(SUM(CASE WHEN tcpi.f_last_check_state = '入户' THEN 1 ELSE 0 END),0) AS data4,
    isnull(SUM(CASE WHEN tcpi.f_last_check_state = '到访不遇' and tcpi.f_check_version >= 3 THEN 1 ELSE 0 END),0) AS data5,
    isnull(SUM(CASE WHEN tcpi.f_last_check_state = '拒检' THEN 1 ELSE 0 END),0) AS data6,
    case when COUNT(0) = 0 then '0.00%' else
    CONVERT(varchar,CONVERT(decimal(10, 2), ((SUM(CASE WHEN tcpi.f_last_check_state = '入户' OR tcpi.f_check_version >= 3 THEN 1 ELSE 0 END) * 100.0) / NULLIF(COUNT(*), 0))))+ '%' end AS data7
FROM
    t_check_plan_item tcpi
    LEFT JOIN t_check_plan tcp ON tcpi.f_plan_id = tcp.id
WHERE
    tcp.f_checker IS NOT NULL and {condition}
GROUP BY
    f_residential_area,
    tcp.f_checker
