﻿SELECT
    isnull(tcp.f_residential_area,'') as f_left_name1,
    isnull(b.f_item_name,'') as f_left_name2,
    sum( 1 ) as f_data1,
    sum( case when b.wcl != b.a and b.yclyh != b.a then 1 else 0 end )  as f_data3,
    sum( 1 ) - sum( case when b.wcl != b.a and b.yclyh != b.a then 1 else 0 end ) - sum( case when b.yclyh = b.a then 1 else 0 end ) as f_data4,
    sum( case when b.yclyh = b.a then 1 else 0 end )  as f_data2
FROM
    t_check_paper tcp
        LEFT JOIN (
        SELECT
            tcp.id,
            tdi.f_item_name,
            count( tdi.id ) AS a,
            sum( CASE WHEN tdi.f_live_dispose='是' or tdi.f_is_repaired in ('已处理') or tdi.f_deal_dispose in ('现场整改') THEN 1 ELSE 0 END ) AS yclyh,
            sum( CASE WHEN tdi.f_deal_dispose in ('未处理','报修','自行处理','自行整改') and f_repaired != '已派维修单' THEN 1 ELSE 0 END ) AS wcl,
            sum( CASE WHEN f_repaired = '已派维修单' AND f_repaired_uploaded != '已传' THEN 1 ELSE 0 END ) AS clzyh
        FROM
            t_check_paper tcp
                LEFT JOIN ( SELECT f_userinfoid, max( f_upload_date ) f_upload_date FROM t_check_paper WHERE f_entry_status = '入户' AND f_defect_content LIKE '%有隐患%' GROUP BY f_userinfoid ) tcp2 ON tcp.f_userinfoid = tcp2.f_userinfoid
                AND tcp.f_upload_date = tcp2.f_upload_date
                LEFT JOIN t_paper_devices tpd ON tcp.id = tpd.f_paper_id
                LEFT JOIN t_devices_items tdi ON tpd.id = tdi.f_device_id
        WHERE
                1 = 1
          AND f_is_defect = 'true'
        GROUP BY
            tcp.id,tdi.f_item_name
    ) b ON tcp.id = b.id
WHERE {condition} and f_defect_content like '%有隐患%' and tcp.f_residential_area is not null and b.f_item_name is not null
GROUP BY
    tcp.f_residential_area,b.f_item_name

