SELECT
    f_checker,
    f_checker_id,
    sum( plannum ) plannum,
    sum( no_plan_num ) no_plan_num,
    sum( wrj ) wrj,
    sum( yrj ) yrj,
    sum( ruhu ) ruhu,
    sum( daofang ) daofang,
    sum( jujian ) jujian,
    CASE
        WHEN SUM(plannum) = 0 THEN 0.00
        ELSE CONVERT(decimal(18,2), (1.00 * (SUM(ruhu) + SUM(daofang) + SUM(jujian)) / SUM(plannum))) * 100
        END AS wclv
FROM
    (
        select
            f_checker,
            f_checker_id,
            COUNT(1) AS plannum,
            0 as no_plan_num,
            SUM(isnull(wrj,0)) AS wrj,
            SUM(isnull(yrj,0)) AS yrj,
            SUM(isnull(ruhu,0)) AS ruhu,
            SUM(isnull(daofang,0)) AS daofang,
            SUM(isnull(jujian,0)) AS jujian
        from (
                 SELECT
                     isnull(tcp.f_checker,tt.f_checker_name) as f_checker,
                     isnull(tcp.f_checker_id,tt.f_checker_id) as f_checker_id,
                     CASE
                         WHEN tcpi.f_state = '未检' or (tcpi.f_state = '已检' and tcpi.F_LAST_CHECK_STATE != '入户')
                             THEN 1
                         ELSE 0
                         END AS wrj,
                     CASE
                         WHEN tcpi.f_state = '已检' and tcpi.F_LAST_CHECK_STATE = '入户'
                             THEN 1
                         ELSE 0
                         END AS yrj,
                     ruhu,daofang,jujian
                 FROM (select * from t_check_plan where f_filialeid in {f_filialeids}) tcp
                          left JOIN (select * from  t_check_plan_item where f_filialeid in {f_filialeids} ) tcpi ON tcp.id = tcpi.f_plan_id
                          left join (
                     select  a.*,
                             CASE
                                 WHEN f_entry_status = '入户'
                                     AND F_NO_CHECKPLAN = '有计划安检'
                                     THEN 1
                                 ELSE 0
                                 END AS ruhu,
                             CASE
                                 WHEN f_entry_status = '到访不遇'
                                     AND F_NO_CHECKPLAN = '有计划安检'
                                     THEN 1
                                 ELSE 0
                                 END AS daofang,
                             CASE
                                 WHEN f_entry_status = '拒检'
                                     AND F_NO_CHECKPLAN = '有计划安检'
                                     THEN 1
                                 ELSE 0
                                 END AS jujian
                     from t_check_paper a
                              inner join
                          (
                              select f_check_item_id,max(f_upload_date) upload_time
                              from t_check_paper group by f_check_item_id
                          ) b on a.f_check_item_id=b.f_check_item_id and b.upload_time=a.f_upload_date
                     WHERE f_filialeid in {f_filialeids}
            {
                f_start_time == $$ :
                $$,
                $
                 and f_offsite_time >= '{f_start_time}'
                $
            }
            {
                f_end_time == $$ :
                $$,
                $
                 and f_offsite_time <= '{f_end_time}'
                $
            }
                 ) tt on tt.f_check_item_id=tcpi.id
                 where  tcp.f_checker is not null and {condition1}
             ) paper
        GROUP BY f_checker_id,f_checker
        UNION
        SELECT
            f_checker,
            f_checker_id,
            0 AS plannum,
            count( t.id ) AS no_plan_num,
            0 AS wrj,
            0 AS yrj,
            sum( rh ) AS ruhu,
            sum( df ) AS daofang,
            sum( jj ) AS jujian
        FROM
            (
                SELECT
                    f_checker_id,
                    f_checker_name AS f_checker,
                    id,
                    CASE
                        WHEN f_entry_status = '入户' THEN
                            1 ELSE 0
                        END AS rh,
                    CASE
                        WHEN f_entry_status = '到访不遇' THEN
                            1 ELSE 0
                        END AS df,
                    CASE
                        WHEN f_entry_status = '拒检' THEN
                            1 ELSE 0
                        END AS jj
                FROM
                    t_check_paper
                WHERE
                        f_no_checkplan = '无计划安检' and f_filialeid in {f_filialeids} and {condition2}
            ) t
        GROUP BY
            f_checker_id,
            f_checker
    ) c
GROUP BY
    f_checker,
    f_checker_id
order by f_checker_id