select
    *
from (
    select
        uf.f_meternumber, --燃气表号
        uf.f_aroundmeter, --左右表
        case gb.f_meter_type
        when '机表' then uf.f_bqf_state
        else (
            case mr.f_valveState when '0' then '开阀' else '关阀' end
        ) end f_valve_state, -- 抄表返回的阀门状态
        gb.f_meter_brand, --燃气表品牌
        gb.f_meter_type, --燃气表类型
        gb.f_alias, --燃气表品牌别名
        ui.f_userinfo_code, --用户编号
        uf.f_userfiles_id,--编号
        ui.f_user_name, --用户姓名
        ui.f_user_phone, --用户电话
        uf.f_user_type, --用户类型
        ua.f_address, --用户地址
        uf.f_off_valve_reason,--开关阀原因
        ua.f_residential_area,--小区
        ua.f_building,--楼号
        ua.f_unit,--单元
        uf.f_meter_base, --气表底数
        uf.f_total_gas, --累计气量
        uf.f_total_fee, --累计金额
        mr.f_batteryLevel2, --碱电电压
        mr.f_jval as f_balance_amount,--预存余额
        uf.f_table_state,
        uf.f_userinfo_id,
        case gb.f_meter_type when '机表' then ui.f_balance else uf.f_balance_amount end f_system_amount, --系统余额
        case gb.f_meter_type when '机表' then r.f_operate_date else i.f_instruct_date end f_instruct_date,
        i.f_instruct_title,
        s.f_collection,
        s.f_operate_date
    from
        t_userfiles uf with (nolock)
        LEFT JOIN t_gasbrand gb with (nolock) on uf.f_gasbrand_id = gb.id
        LEFT JOIN t_userinfo  ui with (nolock) on uf.f_userinfo_id = ui.f_userinfo_id
        LEFT JOIN t_user_address ua with (nolock) on uf.f_userinfo_id = ua.f_userinfo_id
        left join  t_meteread mr with (nolock) on uf.f_meteread_maxid = mr.id
        left join (
            select f_userinfo_id, f_instruct_date, f_instruct_title, f_instruct_type from
            (
                select *,ROW_NUMBER() OVER(PARTITION BY f_userinfo_id ORDER BY f_instruct_date DESC) as num
                from t_instruct with (nolock) where f_instruct_type = '阀门控制' and f_instruct_state = '执行成功'
            ) t where t.num = 1
        )  i  on uf.f_userinfo_id = i.f_userinfo_id
        left join (
            select f_userinfo_id, f_operate_date, f_collection from
            (
                select *,ROW_NUMBER() OVER(PARTITION BY f_userinfo_id ORDER BY f_operate_date DESC) as num
                from t_sellinggas with (nolock) where f_state = '有效'
            ) t where t.num = 1
        )  s  on uf.f_userinfo_id = s.f_userinfo_id
        left join (
            select f_userinfo_id, f_operate_date from
            (
                select *,ROW_NUMBER() OVER(PARTITION BY f_userinfo_id ORDER BY f_operate_date DESC) as num
                from t_record with (nolock) where f_state = '有效'
            ) t where t.num = 1
        )  r  on uf.f_userinfo_id = r.f_userinfo_id
    where uf.f_table_state = '正常' and ui.f_user_state = '正常'
) t
where
    {condition}
order by
    f_meternumber
