SELECT
    f_subcompany,
    isnull(入户, 0 ) rh,
    isnull(到访不遇, 0 ) dfby,
    isnull(未使用天然气, 0 ) wsy,
    isnull(拒检, 0 ) jj
FROM
    (
        SELECT
            u2.f_subcompany,
            u2.f_entry_status,
            COUNT ( u2.f_userinfoid ) counts
        FROM
            t_check_plan_item u1
                LEFT JOIN (
                SELECT
                    *
                FROM
                    (
                        SELECT
                            *,
                            ROW_NUMBER () OVER ( partition BY f_userinfoid ORDER BY f_upload_date DESC ) AS lastcheck
                        FROM
                            (
                                SELECT
                                    f_subcompany,
                                    f_userinfoid,
                                    f_check_item_id,
                                    f_entry_status,
                                    f_safe_type,
                                    f_offsite_time,
                                    f_upload_date
                                FROM
                                    t_check_paper
                                WHERE
                                        f_check_type = '民用'
                                  AND f_offsite_time >= '{startDate} 00:00:00'
                                  AND f_offsite_time <= '{endDate} 23:59:59'
                            ) tp
                    ) t
                WHERE
                        lastcheck = 1
            ) u2 ON u1.id= u2.f_check_item_id
                LEFT JOIN t_check_plan u3 ON u3.id= u1.f_plan_id
                LEFT JOIN t_userinfo tu ON tu.f_userinfo_id = u1.f_userinfoid
        WHERE
             u1.f_user_type = '民用'
            { orgid != $$ :
            $
          AND u1.f_filialeid IN { orgid } $,
            $ $
            }
            { f_safecheck_type != $$ :
			$
			AND u1.f_safecheck_type = '{ f_safecheck_type }' $,
			$ $
			}
          AND ( tu.f_user_state= '正常' OR tu.f_user_state= '停用' ) { plan_type == $ FALSE $ :
            $
          AND tu.f_open_date < DATENAME( YEAR, '{startDate}' ) + '-01-01 00:00:00' $,
            plan_type == $ TRUE $ :
            $
          AND tu.f_open_date > DATENAME( YEAR, '{startDate}' ) + '-01-01 00:00:00' $,
            plan_type == $$ :
            $
          AND 1 = 1 $,
            $$
            }
        GROUP BY
            u2.f_subcompany,
            u2.f_entry_status
    ) AS P PIVOT ( SUM ( counts ) FOR p.f_entry_status IN ( [入户], [到访不遇], [未使用天然气], [拒检] ) ) AS T
ORDER BY
    f_subcompany
