SELECT  m.* FROM (
    SELECT tm.f_meter_no,ti.*,cp.f_plan_name,cp.f_plan_year,cp.f_plan_month,cp.f_checker_id,
           (case PATINDEX('%[^0-9]%', ti.f_building)
                when 0
                    then f_building
                else 999
               end
               ) building,
           (case PATINDEX('%[^0-9]%', ti.f_unit)
                when 0
                    then f_unit
                else 999
               end
               ) unit,
           (case PATINDEX('%[^0-9]%', ti.f_floor)
                when 0
                    then f_floor
                else 999
               end
               ) floor,
           (case PATINDEX('%[^0-9]%', ti.f_room)
                when 0
                    then f_room
                else 999
               end
               )room
    FROM t_check_plan_item ti
    LEFT JOIN t_plan_item_meter tm ON tm.f_plan_item_id = ti.id
    left join t_check_plan cp on cp.id = ti.f_plan_id
    WHERE {condition}
) m
      ORDER BY f_prearranged_date,f_residential_area,building,unit,floor,room,f_address
