SELECT Distinct GroupName
              , BIM.ChargeID
              , BIM.ChargeName
              , BI.InspectionBoundID                                            As id
              , BI.InspectionBoundID
              , InspectionBoundName
              , InspectionBoundDesc
              , AreaAddress
              , BI.DeptID
              , PlanPeriodTypeID
              , IOrder
              , IBoundArea
              , ISNULL(WorkType, '1')                                           As WorkType
              , FormTableID
              , BD.PointCount
              , BD.LineCount
              , Convert(varchar(10), Round(ISNULL(BD.LineLength, 0) / 1000, 2)) as LineLength
              , Case ISNULL(WorkType, '1')
                    When '1' Then N'巡检'
                    Else (select ShortName from T_FORM_FormModule t where WorkType = t.TypeCode)
                    End
    + Case ISNULL(FormTableID, '')
          When '' Then ''
          Else ' (' + (Select stuff((Select ';' + FormName
                                     from T_FORM_FormTable with (nolock)
              Where ID in (Select value from dbo.UTILfn_Split(FormTableID, ','))
              for xml path('')), 1, 1, '')) + ')'
                    End                                                         As ShortName
              , BIBD.pipelineLength
              , BIBD.UrbanValvePit
              , BIBD.CourtyardValvePit
              , BIBD.outPointsCount
              , BIBD.outPressureLevel
              , BIBD.BuriedPipeLength
              , BIBD.OverheadPipeLength
              , BIBD.BuildCount
              , BIBD.YRGCount
              , BIBD.TYXiangCount
              , BIBD.TYGuiCount
              , BIBD.inPointsCount
              , BIBD.inPressureLevel
              , ISNULL(SecurityGroup.myParentCompanyID, '')                     as myParentCompanyID
              , ISNULL(C.EmployeeName, '')                                      as Creater
              , Case ISNULL(BI.CreateDate, '')
                    When '' Then ''
                    Else Convert(varchar(10), BI.CreateDate, 111) + ' ' +
                         Convert(varchar(10), BI.CreateDate, 108) End              CreateDate
              , ISNULL(M.EmployeeName, '')                                      as Modifier
              , Case ISNULL(BI.ModifyDate, '')
                    When '' Then ''
                    Else Convert(varchar(10), BI.ModifyDate, 111) + ' ' +
                         Convert(varchar(10), BI.ModifyDate, 108) End              ModifyDate
FROM Bas_InspectionBound As BI
         Left Join Bas_Employee C on BI.Creater = C.EmployeeID
         Left Join Bas_Employee M on BI.Modifier = M.EmployeeID
         Inner Join SecurityGroup On SecurityGroup.GroupID = BI.DeptID
         Left Join Bas_DeviceInBound as BD on BD.InspectionBoundID = BI.InspectionBoundID
         Left Join
     (select InspectionBoundID,
             ChargeID   = (
                 stuff(
                         (select ',' + bim.EmployeeID
                          from Bas_InspectionBoundmanager bim
                                   left join Bas_Employee be on bim.EmployeeID = be.EmployeeID
                          where bim.InspectionBoundID = A.InspectionBoundID
                             for xml path('')),
                         1,
                         1,
                         ''
                     )
                 ),
             ChargeName = (
                 stuff(
                         (select ',' + EmployeeName
                          from Bas_InspectionBoundmanager bim
                                   left join Bas_Employee be on bim.EmployeeID = be.EmployeeID
                          where bim.InspectionBoundID = A.InspectionBoundID
                             for xml path('')),
                         1,
                         1,
                         ''
                     )
                 )
      from Bas_InspectionBoundmanager as A
      group by InspectionBoundID
     ) as BIM on BI.InspectionBoundID = BIM.InspectionBoundID
         Left Join Bas_InspectionBoundDetail BIBD on BI.InspectionBoundID = BIBD.InspectionBoundID
Where (ISNULL(DelFlag, 0) = 0)
  And (ISNULL(AreaPointsStr, '') = '')
  And ISNULL(PlanPeriodTypeID, 0) = 0
  And (GroupID in (select GroupID from fn_GetGroupTree('XYTRQ')))
  And (ISNULL(WorkType, '1') in (Select Distinct A.TypeCode
      from T_FORM_FormModule A
           inner join T_FORM_FormTable B on A.TypeCode = B.FormType
           inner join Bas_EmployeeRoles C
            on C.DMSRoleID in (select * from dbo.UTILfn_Split(B.RoleID, ','))
      Where (A.IsDeleted is null or A.IsDeleted = 0)
        and A.IsArrangementPlan = 1
        And B.Status = 1
        and A.State = 1
        And ISNULL(A.PlanCreateWay, 2) <> 2
        And C.EmployeeID = '007') or (ISNULL(WorkType, '1') = '1'))
Order By CreateDate Desc
