SELECT
    ta.*,
    area.areanum
FROM
    (
        SELECT
            f_checker_idhp,
            f_checker_namehp,
            COUNT ( 1 ) AS plannum,
            SUM (
                    isnull( wrj, 0 )) AS wrj,
            SUM (
                    isnull( yrj, 0 )) AS yrj,
            SUM (
                    isnull( ruhu, 0 )) AS ruhu,
            SUM (
                    isnull( daofang, 0 )) AS daofang,
            SUM (
                    isnull( jujian, 0 )) AS jujian,
            SUM (
                    isnull( weijian, 0 )) AS weijian,
            SUM (
                    isnull( yijian, 0 )) AS yijian,
            CAST (
                    CONVERT (
                            DECIMAL ( 18, 2 ),
                            CASE

                                WHEN COUNT ( * ) = 0 THEN
                                    0.00 ELSE SUM (
                                                      isnull( yrj, 0 )) / ( COUNT ( * ) + 0.00 ) * 100.00
                                END
                        ) AS VARCHAR
                ) + '%' ruhulv,
            CAST (
                    CONVERT (
                            DECIMAL ( 18, 2 ),
                            CASE

                                WHEN COUNT ( * ) = 0 THEN
                                    0.00 ELSE SUM (
                                                      isnull( yijian, 0 )) / ( COUNT ( * ) + 0.00 ) * 100.00
                                END
                        ) AS VARCHAR
                ) + '%' anjianlv
        FROM
            (
                SELECT
                    tcpi.f_checker_idhp,
                    tcpi.f_checker_namehp,
                    CASE

                        WHEN tcpi.f_state = '未检'
                            OR ( tcpi.f_state = '已检' AND tcpi.F_LAST_CHECK_STATE != '入户' ) THEN
                            1 ELSE 0
                        END AS wrj,
                    CASE

                        WHEN tcpi.f_state = '已检'
                            AND tcpi.F_LAST_CHECK_STATE = '入户' THEN
                            1 ELSE 0
                        END AS yrj,
                    CASE

                        WHEN tcpi.f_state = '已检' THEN
                            1 ELSE 0
                        END AS yijian,
                    CASE

                        WHEN tcpi.f_state = '未检' THEN
                            1 ELSE 0
                        END AS weijian,
                    CASE

                        WHEN tcpi.f_state = '已检'
                            AND tcpi.f_last_check_state = '入户' { f_start_time == $$ :
                $$,
                $
                        AND f_last_check_date >= '{f_start_time}' $
                    }
								{ f_end_time == $$ :
                $$,
                $
								AND f_last_check_date <= '{f_end_time}' $
								} THEN
									1 ELSE 0
								END AS ruhu,
							CASE

									WHEN tcpi.f_state = '已检'
									AND tcpi.f_last_check_state = '到访不遇' { f_start_time == $$ :
									$$,
									$
									AND f_last_check_date >= '{f_start_time}' $
									}
									{ f_end_time == $$ :
									$$,
									$
									AND f_last_check_date <= '{f_end_time}' $
									} THEN
										1 ELSE 0
									END AS daofang,
								CASE

										WHEN tcpi.f_state = '已检'
										AND tcpi.f_last_check_state = '拒检' { f_start_time == $$ :
										$$,
										$
										AND f_last_check_date >= '{f_start_time}' $
										}
										{ f_end_time == $$ :
										$$,
										$
										AND f_last_check_date <= '{f_end_time}' $
										} THEN
											1 ELSE 0
										END AS jujian
                FROM
                    t_check_plan_item tcpi
                    LEFT JOIN t_check_plan tcp ON tcp.id = tcpi.f_plan_id
                WHERE
                    tcp.f_checker IS NOT NULL
                  AND tcpi.f_checker_idhp IS NOT NULL
                  AND tcpi.f_state != '作废'
                    {condition}
            ) paper
        GROUP BY
            f_checker_idhp,
            f_checker_namehp
    ) ta
        LEFT JOIN (
        SELECT
            f_checker_idhp,
            COUNT ( 0 ) areanum
        FROM
            ( SELECT f_checker_idhp, f_residential_area FROM t_check_plan_item WHERE f_checker_idhp IS NOT NULL AND f_state != '作废' GROUP BY f_checker_idhp, f_residential_area ) tb
        GROUP BY
            f_checker_idhp
    ) area ON ta.f_checker_idhp = area.f_checker_idhp
