--根据年份查出月计划项数目
select
    f_checker,
    f_checker_id,
    COUNT(1) AS plannum,
    SUM(isnull(wrj,0)) AS wrj,
    SUM(isnull(yrj,0)) AS yrj,
    SUM(isnull(ruhu,0)) AS ruhu,
    SUM(isnull(daofang,0)) AS daofang,
    SUM(isnull(jujian,0)) AS jujian,
    SUM(isnull(weijian,0)) AS weijian,
    SUM(isnull(fufang,0)) AS fufang,
    SUM(isnull(yijian,0)) AS yijian,
    cast(Convert(decimal(18,2),case when count(*)=0 then 0.00 else SUM(isnull(yrj,0))/(count(*)+0.00)*100.00 end)  as varchar)+'%'  ruhulv,
    cast(Convert(decimal(18,2),case when count(*)=0 then 0.00 else SUM(isnull(yijian,0))/(count(*)+0.00)*100.00 end)  as varchar)+'%'  anjianlv
from (
         SELECT
             tcp.f_checker,
             tcp.f_checker_id,
             CASE
                 WHEN tcpi.f_state = '未检' or (tcpi.f_state = '已检' and tcpi.F_LAST_CHECK_STATE != '入户')
                     THEN 1
                 ELSE 0
                 END AS wrj,
             CASE
                 WHEN tcpi.f_state = '已检' and tcpi.F_LAST_CHECK_STATE = '入户'
                     THEN 1
                 ELSE 0
                 END AS yrj,
             CASE
                 WHEN tcpi.f_state = '已检'
                     THEN 1
                 ELSE 0
                 END AS yijian,
             CASE
                 WHEN tcpi.f_state = '未检'
                     THEN 1
                 ELSE 0
                 END AS weijian,
             CASE
                 WHEN tcpi.f_state = '已检' and  tcpi.f_last_check_state = '到访不遇'
                     {
                f_start_time == $$ :
                $$,
                $
                 and f_last_check_date >= '{f_start_time}'
                        $
             }
            {
                f_end_time == $$ :
                $$,
                $
                 and f_last_check_date <= '{f_end_time}'
                $
            }
            AND tcpi.f_check_version >1
            THEN 1
        ELSE 0
        END AS fufang,
				    CASE
        WHEN tcpi.f_state = '已检' and  tcpi.f_last_check_state = '入户'
				 {
                f_start_time == $$ :
                $$,
                $
                 and f_last_check_date >= '{f_start_time}'
                $
            }
            {
                f_end_time == $$ :
                $$,
                $
                 and f_last_check_date <= '{f_end_time}'
                $
            }
            THEN 1
        ELSE 0
        END AS ruhu,
			 CASE
        WHEN tcpi.f_state = '已检' and  tcpi.f_last_check_state = '到访不遇'
				 {
                f_start_time == $$ :
                $$,
                $
                 and f_last_check_date >= '{f_start_time}'
                $
            }
            {
                f_end_time == $$ :
                $$,
                $
                 and f_last_check_date <= '{f_end_time}'
                $
            }
            THEN 1
        ELSE 0
        END AS daofang,
				 CASE
        WHEN tcpi.f_state = '已检' and  tcpi.f_last_check_state = '拒检'
				 {
                f_start_time == $$ :
                $$,
                $
                 and f_last_check_date >= '{f_start_time}'
                $
            }
            {
                f_end_time == $$ :
                $$,
                $
                 and f_last_check_date <= '{f_end_time}'
                $
            }
            THEN 1
        ELSE 0
        END AS jujian


         FROM t_check_plan_item tcpi
             left JOIN t_check_plan tcp ON tcp.id = tcpi.f_plan_id
         where  tcp.f_checker is not null and {condition}  and tcpi.f_state != '作废'
     ) paper
GROUP BY f_checker_id,f_checker
order by f_checker
