SELECT COUNT
           ( * ) f_plan_total,
       SUM ( f_yijian ) f_yijian,
       SUM ( f_weijian ) f_weijian,
       SUM ( f_jhruhu ) f_jhruhu,
       SUM ( f_ruhu ) f_ruhu,
       SUM ( f_buyu ) f_buyu,
       SUM ( f_fufang ) f_fufang,
       SUM ( f_jujian ) f_jujian,
       CAST (
               CONVERT (
                       DECIMAL ( 18, 2 ),
                       CASE

                           WHEN COUNT ( * ) = 0 THEN
                               0.00 ELSE SUM ( f_jhruhu ) / ( COUNT ( * ) + 0.00 ) * 100.00
                           END
                   ) AS VARCHAR
           ) + '%' f_check_bv,
       CAST (
               CONVERT (
                       DECIMAL ( 18, 2 ),
                       CASE

                           WHEN COUNT ( * ) = 0 THEN
                               0.00 ELSE SUM ( f_yijian ) / ( COUNT ( * ) + 0.00 ) * 100.00
                           END
                   ) AS VARCHAR
           ) + '%' anjianlv,
    { groupName }
FROM
    (
    SELECT
    cpi.f_street,
    cpi.f_user_type,
    cpi.f_no_checkplan,
    cpi.f_residential_area,
    cpi.f_plan_id,
    cpl.f_plan_name,
    cpl.f_start_time,
    cpl.f_end_time,
    cpi.f_filialeid,
    cpl.f_plan_year AS f_year,
    cpl.f_plan_month AS f_month,
    CAST ( cpl.f_plan_year AS VARCHAR ) + '年' + CAST ( cpl.f_plan_month AS VARCHAR ) + '月' f_plan_month,
    cpl.f_checker f_checker_name,
    CASE

    WHEN cpi.f_state= '已检' THEN
    1 ELSE 0
    END f_yijian,
    CASE

    WHEN cpi.f_state = '未检' THEN
    1 ELSE 0
    END f_weijian,
    CASE

    WHEN cpi.f_state= '已检'
    AND cpi.f_last_check_state= '入户' THEN
    1 ELSE 0
    END f_jhruhu,
    CASE

    WHEN cpi.f_state= '已检'
    AND cpi.f_last_check_state= '入户' { f_start_time == $$ :
    $$,
    $
    AND cpi.f_last_check_date >= '{f_start_time}' $
    }
    { f_end_time == $$ :
    $$,
    $
    AND cpi.f_last_check_date <= '{f_end_time}' $
    } THEN
    1 ELSE 0
    END f_ruhu,
    CASE

    WHEN cpi.f_state= '已检'
    AND cpi.f_last_check_state= '到访不遇' { f_start_time == $$ :
    $$,
    $
    AND cpi.f_last_check_date >= '{f_start_time}' $
    }
    { f_end_time == $$ :
    $$,
    $
    AND cpi.f_last_check_date <= '{f_end_time}' $
    } THEN
    1 ELSE 0
    END f_buyu,
    CASE

    WHEN cpi.f_state= '已检'
    AND cpi.f_last_check_state= '拒检' { f_start_time == $$ :
    $$,
    $
    AND cpi.f_last_check_date >= '{f_start_time}' $
    }
    { f_end_time == $$ :
    $$,
    $
    AND cpi.f_last_check_date <= '{f_end_time}' $
    } THEN
    1 ELSE 0
    END f_jujian,
    CASE

    WHEN cpi.f_state= '已检'
    AND cpi.f_last_check_state= '到访不遇'
    AND cpi.f_check_version > 1 { f_start_time == $$ :
    $$,
    $
    AND cpi.f_last_check_date >= '{f_start_time}' $
    }
    { f_end_time == $$ :
    $$,
    $
    AND cpi.f_last_check_date <= '{f_end_time}' $
    } THEN
    1 ELSE 0
    END f_fufang
    FROM
    t_check_plan_item cpi
    LEFT JOIN t_check_plan cpl ON cpi.f_plan_id = cpl.id
    WHERE
    cpi.f_state!= '作废'
    ) ch
WHERE
    { condition }
  AND f_plan_name != '未分配计划'
GROUP BY
    { groupName }
ORDER BY
    { groupName }
