SELECT
	t1.f_checker_name,
	ruhu+ISNULL( t2.daofang3, 0 ) as ruhu,
	ISNULL( yijian, 0 ) as yijian,
	ISNULL( daofang, 0 ) AS daofang,
	ISNULL( t2.daofang3, 0 ) AS daofang3,
	ISNULL( jujian, 0 ) AS jujian
FROM
	(
		SELECT
			f_checker_name,
			sum(case when f_entry_status = '入户' then 1 else 0 end) AS ruhu,
			sum(case when f_entry_status = '到访不遇' then 1 else 0 end) AS daofang,
			sum(case when f_entry_status = '拒检' then 1 else 0 end) AS jujian,
			sum(1) AS yijian
		FROM
			(
				SELECT
					*,
					ROW_NUMBER ( ) OVER ( partition BY f_userinfoid ORDER BY f_upload_date DESC ) AS rn
				FROM
					t_check_paper
				WHERE
					{ condition }
			) AS u
		WHERE
				u.rn= 1
		GROUP BY
			f_checker_name
	) t1 LEFT JOIN (
		SELECT
			f_checker_name,
			COUNT ( 0 ) AS daofang3
		FROM
			(
				SELECT
					*,
					ROW_NUMBER ( ) OVER ( partition BY f_userinfoid ORDER BY f_upload_date DESC ) AS rn
				FROM
					t_check_paper
				WHERE
						f_entry_status = '到访不遇'
				  AND { condition }
			) AS u
		WHERE
				u.rn= 3
		GROUP BY
			f_checker_name
	) t2 ON t1.f_checker_name= t2.f_checker_name
order by t1.f_checker_name
