SELECT SUM(hushu)                                          AS hushu,
       SUM(ruhu) + SUM(daofang) + SUM(jujian)              AS yijian,
       SUM(ruhu)                                           AS ruhu,
       SUM(daofang)                                        AS daofang,
       SUM(jujian)                                         AS jujian,
       SUM(hushu) - SUM(ruhu) - SUM(daofang) - SUM(jujian) AS weijian,
       CASE
           WHEN (SUM(ruhu) + SUM(daofang) + SUM(jujian)) = 0 THEN
               '0%'
           ELSE cast(CONVERT(
                   NUMERIC(19, 2),
                   (SUM(ruhu) + SUM(daofang) + SUM(jujian)) * 100 / SUM(hushu)
               ) AS varchar) + '%'
           END                                             AS anjianlv,
       CASE
           WHEN (SUM(jujian) + SUM(ruhu) + SUM(daofang)) = 0 THEN
               '0%'
           ELSE cast(CONVERT(
                   NUMERIC(19, 2),
                   SUM(ruhu) * 100 /
                   (SUM(ruhu) + SUM(daofang) + SUM(jujian))
               ) AS varchar) + '%'
           END                                             AS ruhulv,
       f_orgname
FROM (SELECT SUM(ruhu)    AS ruhu,
             SUM(daofang) AS daofang,
             SUM(jujian)  AS jujian,
             SUM(hushu)   AS hushu,
             f_orgname
      FROM (SELECT ui.f_orgname,
                   CASE
                       WHEN tp.rh != 0 THEN 1
                       ELSE 0 END                    ruhu,
                   CASE
                       WHEN tp.rh = 0 AND tp1.f_entry_status = '到访不遇' THEN 1
                       ELSE 0 END                    daofang,
                   CASE
                       WHEN tp.rh = 0 AND tp1.f_entry_status = '拒检' THEN 1
                       ELSE 0 END                    jujian,
                   CASE WHEN 1 = 1 THEN 1 ELSE 0 END hushu
            FROM t_userinfo ui
                     LEFT JOIN t_user_address ua ON ui.f_userinfo_id = ua.f_userinfo_id
                     LEFT JOIN (SELECT f_user_type,
                                       f_meter_book_num,
                                       f_userinfo_id,
                                       f_meter_classify,
                                       f_gasproperties,
                                       f_meternumber,
                                       f_meter_brand,
                                       f_gas_date
                                FROM t_userfiles tu
                                         LEFT JOIN t_gasbrand gb ON tu.f_gasbrand_id = gb.id
                                WHERE f_table_state = '正常') uf ON ua.f_userinfo_id = uf.f_userinfo_id
                     LEFT JOIN (SELECT f_userinfoid,
                                       SUM(CASE WHEN f_entry_status = '入户' THEN 1 ELSE 0 END)     rh,
                                       SUM(CASE WHEN f_entry_status = '到访不遇' THEN 1 ELSE 0 END) df,
                                       SUM(CASE WHEN f_entry_status = '拒检' THEN 1 ELSE 0 END)     jj
                                FROM t_check_paper
                                WHERE f_upload_date > DATEADD(yy, DATEDIFF(yy, 0, getdate()), 0)
                                GROUP BY f_userinfoid) tp ON ui.f_userinfo_id = tp.f_userinfoid
                     LEFT JOIN (SELECT f_userinfoid,
                                       f_entry_status,
                                       f_onsite_time,
                                       ROW_NUMBER() over ( partition BY f_userinfoid ORDER BY f_upload_date DESC ) AS lastcheck
                                FROM t_check_paper
                                WHERE f_entry_status != '入户') tp1
                               ON ui.f_userinfo_id = tp1.f_userinfoid AND lastcheck = 1
            WHERE ui.f_user_state != '无效'
              AND ui.f_user_state != '销户'
              AND ui.f_orgname IS NOT NULL) t
      GROUP BY f_orgname) tt
GROUP BY f_orgname
ORDER BY f_orgname