SELECT f_device_type,
		f_item_value,
		f_defect_level,
		count(*) hiddennum,
        sum (case when f_is_repaired = '未处理' then 1 else 0 end) "unprocessed",
        sum (case when f_is_repaired = '已处理' then 1 else 0 end) "processed"
 FROM (
SELECT tpd.f_device_type,
		tdi.f_item_name+':'+tdil.f_item_value  f_item_value,
		isnull(tdi.f_defect_level,'') f_defect_level,
        isnull(tdi.f_is_repaired,'未处理') f_is_repaired
from
t_check_paper tp,
t_paper_devices tpd,
t_devices_items tdi,
t_devices_items_lists tdil,
t_user usr
WHERE tp.id=tpd.f_paper_id and tpd.id=tdi.f_device_id and tdi.id=tdil.f_item_id and usr.id = tp.f_checker_id
and tdi.f_is_defect='true' and {condition}
{
  f_filialeid!=$$:
  $ and tp.f_filialeid in {f_filialeid}$,
  $$
}
{
startDate!=$$:$ and  tp.f_offsite_time>='{startDate}'$,$$
}
{
endDate!=$$:$  and  tp.f_offsite_time<='{endDate}'$,$$
}
) h
GROUP BY h.f_device_type,h.f_item_value,h.f_defect_level
