select *
from (
         select ui.f_userinfo_code,
                ui.f_balance,
                ui.f_userinfo_id,
                ui.f_user_name,
                ui.f_user_state,
                ui.f_user_phone,
                ui.version as userinfo_version,
                uf.f_user_id,
                uf.version,
                uf.f_balance_amount,
                uf.f_table_state,
                uf.f_meter_classify,
                uf.f_meternumber,
                uf.f_user_type,
                uf.f_filialeids,
                uf.f_gasproperties,
                uf.f_meter_base,
                uf.f_orgid,
                uf.f_userfiles_id,
                ua.f_address,
                ua.f_residential_area,
                ua.f_residential_area_id,
                ua.f_building,
                ua.f_unit,
                ua.f_floor,
                ua.f_room,
                gb.f_meter_type,
                gb.f_meter_brand,
                gb.f_alias,
                gb.f_collection_type,
                gb.f_isdecimal,
                gm.f_meter_style
         from t_userfiles uf
                  left join t_userinfo ui on uf.f_userinfo_id = ui.f_userinfo_id
                  left join t_user_address ua on uf.f_useraddress_id = ua.id
                  left join t_gasbrand gb on uf.f_gasbrand_id = gb.id
                  left join t_gasmodel gm on uf.f_gasmodel_id = gm.id
                  left join (select *
                             from t_stairprice
                             where f_state = '有效' and getdate() >= f_perform_date and getdate() <= f_end_date) sp
                            on uf.f_price_id = sp.f_price_id
         where uf.f_table_state = '待开通'
           and uf.f_meter_classify = '物联网表'
     ) t
where
    { condition }
order by
    f_userinfo_id desc
