package com.aote.util;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.Iterator;

public class JsonUtils {

    public static JSONObject getJsonObject (String str) {
        return new JSONObject(str);
    }

    public static JSONArray getJsonArray(String str) {
        return new JSONArray(str);
    }

    public static String defectContentConvertToDefectStr(String str) {
        final JSONObject jsonObject = getJsonObject(str);
        final JSONArray data = jsonObject.getJSONArray("data");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < data.length(); i++) {
            JSONObject jsonObject1 = data.getJSONObject(i);
            final Iterator<String> keys = jsonObject1.keys();
            while (keys.hasNext()) {
                final String next = keys.next();
                stringBuilder.append(next);
                stringBuilder.append(":");
                stringBuilder.append(jsonObject1.optString(next));
                stringBuilder.append(";");
            }
        }
        return stringBuilder.toString();
    }

    public static String defectContentConvertToDefectStr(String str, int num) {
        StringBuilder stringBuilder = new StringBuilder();
        final String res = defectContentConvertToDefectStr(str);
        final String[] splitStr = res.split(";");
        for (String s : splitStr) {
            if (stringBuilder.toString().length() + s.length() > num) {
                return stringBuilder.toString();
            }
            stringBuilder.append(s);
        }
        return res;
    }

    public static JSONArray defectContentConvertToDefectArray(String str) {
        JSONArray jsonArray = new JSONArray();
        final String res = defectContentConvertToDefectStr(str);
        final String[] split = res.split(";");
        for (String s : split) {
            jsonArray.put(s);
        }
        return jsonArray;
    }

}
