package com.aote.timer;

import com.aote.rs.LogicService;
import com.google.gson.JsonObject;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author xiaoyufan
 * @Date 2022-01-14
 * <p>
 * 概要：温宿定时拉黑接口
 */
public class WenSuBatchMask {
    private final static Logger log = Logger.getLogger(WenSuBatchMask.class);
    @Autowired
    private LogicService logicService;

    public void  batchMask() {
        try {
            JSONArray query=new JSONArray(logicService.xtSave("safe_get_blactlist","{data:{}}"));
            if(query.length()>0){
                log.debug("获取用户信息---"+ query.toString());
                JSONObject obj=new JSONObject();
                obj.put("condition"," 1=1");
                obj.put("switchCheckAll",false);
                obj.put("checkAll",false);
                obj.put("param",query);
                obj.put("type","send");
                obj.put("columnName","f_userinfo_code");
                log.debug("obj========---"+ obj.toString());
                logicService.xtSave("safe_getuser_to_blactlist","{data:"+obj.toString()+"}");
                log.debug("执行完成");
            }
        } catch (Exception e) {
            log.error("安检系统向第三方推送拉黑信息，执行错误，错误原因：\n",e);
            e.printStackTrace();
        }
    }
}
