package com.aote.timer;

import com.aote.rs.LogicService;
import com.aote.rs.SqlService;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

/**
 * com.aote.timer
 *
 * @author Administrator
 * @creater 2020-07-07 15:52
 */
public class ChangeUserFilesTimer {

    @Autowired
    private LogicService logicService;
    static Logger log = Logger.getLogger(LogicService.class);

    public String getLogicName() {
        return logicName;
    }

    public void setLogicName(String logicName) {
        this.logicName = logicName;
    }

    public String getLogicPath() {
        return logicPath;
    }

    public void setLogicPath(String logicPath) {
        this.logicPath = logicPath;
    }

    private String logicName;
    private String logicPath;
    public void checkChangeUserFiles() throws Exception{
        changeFiles();
        log.debug("定时器执行完成++++++++++++++++++++");
    }
    @Transactional(readOnly=true)
    public void changeFiles() throws Exception{

        String s = readFileContent(ChangeUserFilesTimer.class.getResource("/").getPath() + "changeFileConfig.json");


        JSONArray json = new JSONArray(s);
        json.forEach(res->{

            try {
                String result = logicService.xtSave("AutoChangeUserFiles", res.toString());
                System.out.println("更新结果==》"+result);
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
    public static String readFileContent(String fileName) {
        File file = new File(fileName);
        BufferedReader reader = null;
        StringBuffer sbf = new StringBuffer();
        try {
            reader = new BufferedReader(new FileReader(file));
            String tempStr;
            while ((tempStr = reader.readLine()) != null) {
                sbf.append(tempStr);
            }
            reader.close();
            return sbf.toString();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return sbf.toString();
    }
}
