package com.aote.plugins;

import com.aote.logic.LogicMapper;
import com.aote.logic.LogicServer;
import com.aote.path.PathMapper;
import com.aote.sql.SqlMapper;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

/**
 * @Author: JoeCdy
 * @Description:
 * @Date: Created in 14:29 2020/7/9
 */
@Component
public class FilialeReplace {

    static Logger log = Logger.getLogger(FilialeReplace.class);

    @Autowired
    private LogicServer logicServer;

    /**
     * logic业务逻辑根据分公司进行覆盖或添加
     */
    public static void logicReplace(String filiale) {
        try {
            filiale = filiale.toLowerCase();
            log.debug("分公司logic替换===>" + filiale);
            // 分公司logic映射文件
            String str = filiale + File.separator + "logic.xml";
            InputStream moduleLogic = LogicMapper.class.getClassLoader()
                    .getResourceAsStream(str);

            if (moduleLogic == null) {
                throw new RuntimeException("找不到分公司logic配置文件：" + str);
            }
            SAXReader reader = new SAXReader();
            Document docLogic = reader.read(moduleLogic);
            Element rootLogic = docLogic.getRootElement();
            for (Iterator item = rootLogic.elementIterator("logic"); item.hasNext(); ) {
                Element elmment = (Element) item.next();
                String aliasLogic = elmment.attribute("alias").getValue();
                String pathLogic = elmment.attribute("path").getValue();
                String log = elmment.attributeValue("log");
                String mobile = elmment.attributeValue("mobile");
                // 完整logic路径
                String path = filiale + File.separator + "logics" + File.separator + pathLogic;
                // 设置业务逻辑属性
                Map<String, String> logic = new HashMap<>();
                logic.put("alias", aliasLogic);
                logic.put("path", path);
                logic.put("log", log);
                logic.put("mobile", mobile);
                // 进行替换或新增
                FilialeReplace.log.debug("alias:" + aliasLogic + "===>path:" + path);
                LogicMapper.getMap().put(aliasLogic, logic);
            }
        } catch (Exception e) {
            log.debug("分公司logic替换异常===>" + e);
        }
    }

    /**
     * sql根据分公司进行覆盖或添加
     */
    public static void sqlReplace(String filiale) {
        try {
            filiale = filiale.toLowerCase();
            log.debug("分公司sql替换===>" + filiale);
            // 分公司logic映射文件
            String str = filiale + File.separator + "sql.xml";
            InputStream moduleLogic = LogicMapper.class.getClassLoader()
                    .getResourceAsStream(str);

            if (moduleLogic == null) {
                throw new RuntimeException("找不到分公司sql配置文件：" + str);
            }
            SAXReader reader = new SAXReader();
            Document docLogic = reader.read(moduleLogic);
            Element rootLogic = docLogic.getRootElement();
            for (Iterator item = rootLogic.elementIterator("sql"); item.hasNext(); ) {
                Element elmment = (Element) item.next();
                String aliasLogic = elmment.attribute("alias").getValue();
                String pathLogic = elmment.attribute("path").getValue();
                String mobile = elmment.attributeValue("mobile");
                // 完整sql路径
                String path = filiale + File.separator + "sqls" + File.separator + pathLogic;
                // 设置sql属性
                Map<String, String> logic = new HashMap<>();
                logic.put("alias", aliasLogic);
                logic.put("path", path);
                logic.put("mobile", mobile);
                // 进行替换或新增
                FilialeReplace.log.debug("alias:" + aliasLogic + "===>path:" + path);
                SqlMapper.getMap().put(aliasLogic, logic);
            }
        } catch (Exception e) {
            log.debug("分公司sql替换异常===>" + e);
        }
    }


    public static void pathReplace(String filiale) {
        try {
            filiale = filiale.toLowerCase();
            log.debug("分公司path替换===>" + filiale);
            // 分公司logic映射文件
            String str = filiale + File.separator + "path.xml";
            InputStream moduleLogic = LogicMapper.class.getClassLoader()
                    .getResourceAsStream(str);

            if (moduleLogic == null) {
                throw new RuntimeException("找不到分公司path配置文件：" + str);
            }
            SAXReader reader = new SAXReader();
            Document docLogic = reader.read(moduleLogic);
            Element rootLogic = docLogic.getRootElement();
            for (Iterator item = rootLogic.elementIterator("path"); item.hasNext(); ) {
                Element elmment = (Element) item.next();
                String aliasLogic = elmment.attribute("alias").getValue();
                String pathLogic = elmment.attribute("path").getValue();
                String log = elmment.attributeValue("log");
                String mobile = elmment.attributeValue("mobile");
                // 完整path路径
                String paths = filiale + File.separator + "paths" + File.separator + pathLogic;
                // 设置业务逻辑属性
                Map<String, String> path = new HashMap<>();
                path.put("alias", aliasLogic);
                path.put("path", paths);
                path.put("log", log);
                path.put("mobile", mobile);
                // 进行替换或新增
                FilialeReplace.log.debug("alias:" + aliasLogic + "===>path:" + paths);
                PathMapper.getMap().put(aliasLogic,path);
            }
        } catch (Exception e) {
            log.debug("分公司path替换异常===>" + e);
        }
    }

    /**
     * report根据分公司进行覆盖或添加
     */
//    public static void reportReplace(String filiale) {
//        try {
//            log.debug("分公司report替换===>" + filiale);
//            // 分公司logic映射文件
//            String str = filiale + File.separator + "report.xml";
//            InputStream moduleLogic = LogicMapper.class.getClassLoader()
//                    .getResourceAsStream(str);
//
//            if (moduleLogic == null) {
//                throw new RuntimeException("找不到分公司report配置文件：" + str);
//            }
//            SAXReader reader = new SAXReader();
//            Document docLogic = reader.read(moduleLogic);
//            Element rootLogic = docLogic.getRootElement();
//            for (Iterator item = rootLogic.elementIterator("report"); item.hasNext(); ) {
//                Element elmment = (Element) item.next();
//                String aliasLogic = elmment.attribute("alias").getValue();
//                String pathLogic = elmment.attribute("path").getValue();
//                // 完整report路径
//                String path = "/" + filiale + File.separator + "reports" + File.separator + pathLogic;
//                // 进行替换或新增
//                FilialeReplace.log.debug("alias:" + aliasLogic + "===>path:" + path);
//                ReportMapper.getReport().put(aliasLogic, path);
//            }
//        } catch (Exception e) {
//            log.debug("分公司report替换异常===>" + e);
//        }
//    }

    /**
     * 重新加载模块至readis
     */
    public void redisCache() {
        try {
            logicServer.redisCacheLogic();
        } catch (Exception e) {
            log.debug("重新加载模块到readis异常", e);
        }
    }


}
