select
t1.company,
t1.department,
t1.checker,
count(0) as plan_count,
sum(case when t1.f_entry_status = '入户' then 1 else 0 end) as household_count,
sum(case when t1.f_state = '已检' then 1 else 0 end) as checked_count,
sum(case when t1.f_state != '已检' then 1 else 0 end) as unchecked_count,
sum(case when t1.f_entry_status = '拒检' then 1 else 0 end) as reject_count,
sum(case when t1.f_entry_status = '到访不遇' then 1 else 0 end) as never_met_count,
isnull(round((sum(case when t1.f_state = '已检' then 1 else 0 end)/cast(count(0) as float))*100,1),0) as checked_rate,
isnull(round((sum(case when t1.f_entry_status = '入户' then 1 else 0 end)/cast(sum(case when t1.f_state = '已检' then 1 else 0 end) as float))*100,1),0) as household_rate
from
(
	select
	o.name as company,
	d.name as department,
	u.name as checker,
	c_p.f_no_checkplan,
	c_p.f_entry_status,
	c_p.f_state
	from
	t_organization o,
	t_department d,
	t_user u,
	t_check_paper c_p
	where
	o.id = d.parentid
	and d.id = u.parentid
	and u.id = c_p.f_checker_id
	and f_no_checkplan = '有计划安检'
	{
      f_subcompany!=$$:
      $ and o.name = '{f_subcompany}'$,
      $$
    }
    {
      department!=$$:
      $
        and d.name = '{department}'
      $,$$
    }
    {
      startDate!=$$:$ and  c_p.f_offsite_time>='{startDate}'$,$$
    }
    {
      endDate!=$$:$  and  c_p.f_offsite_time<='{endDate}'$,$$
    }
) t1
group by
t1.company,
t1.department,
t1.checker
