/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.sql.SqlServer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.transaction.Transactional;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Path(value="location")
@Scope(value="prototype")
@Component
@Transactional
public class LocationService {
    @Autowired
    private SqlServer sqlServer;
    static Logger log = Logger.getLogger(LocationService.class);
    @Autowired
    private SessionFactory sessionFactory;

    @Path(value="getLastInfo")
    @POST
    public String getLastInfo(String str) {
        log.debug((Object)("---\u5f00\u59cb\u83b7\u53d6\u6700\u65b0\u4f4d\u7f6e\u4fe1\u606f\uff0c\u4f20\u5165\u6570\u636e=>" + str));
        JSONObject jo = null;
        JSONObject result = new JSONObject();
        try {
            String condition = " 1=1 ";
            jo = new JSONObject(str);
            if (!jo.isNull("date")) {
                condition = condition + " and SUBSTRING(f_realtime,0,11)='" + jo.getString("date") + "' ";
            }
            JSONArray array = this.sqlServer.query("select t1.* from t_phone_state t1,(select f_user_id,max(id) mid from t_phone_state where " + condition + " group by  f_user_id) t2 where t1.id=t2.mid");
            JSONObject item = null;
            JSONObject row = null;
            JSONArray data = new JSONArray();
            for (int i = 0; i < array.length(); ++i) {
                item = array.getJSONObject(i);
                row = new JSONObject();
                row.put("id", (Object)item.getString("f_user_id"));
                row.put("updateTime", (Object)item.getString("f_realtime"));
                row.put("status", this.checkOnLine(item.getString("f_realtime")));
                row.put("name", (Object)item.getString("f_user_name"));
                row.put("latitude", (Object)item.getString("f_longitude"));
                row.put("longitude", (Object)item.getString("f_latitude"));
                data.put((Object)row);
            }
            result.put("data", (Object)data);
            result.put("success", true);
            log.debug((Object)("\u67e5\u8be2\u5230\u7684\u6700\u540e\u4e00\u6b21\u4f4d\u7f6e\u4fe1\u606f\u6570\u636e:" + array.toString()));
        }
        catch (Exception e) {
            log.debug((Object)("\u83b7\u53d6\u6700\u65b0\u4f4d\u7f6e\u4fe1\u606f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f=>" + e.getMessage()));
            result.put("success", false);
            result.put("msg", (Object)e.getMessage());
        }
        log.debug((Object)("\u83b7\u53d6\u6700\u65b0\u4f4d\u7f6e\u4fe1\u606f\u6210\u529f\uff0c\u8fd4\u56de\u6570\u636e:" + result.toString()));
        return result.toString();
    }

    @Path(value="getWhileInfo")
    @POST
    public String getWhileInfo(String str) {
        log.debug((Object)("---\u5f00\u59cb\u83b7\u53d6\u8f68\u8ff9\u4fe1\u606f\uff0c\u4f20\u5165\u6570\u636e=>" + str));
        JSONObject jo = null;
        JSONObject result = new JSONObject();
        try {
            String condition = " 1=1 ";
            jo = new JSONObject(str);
            if (jo.isNull("beginTime") || jo.isNull("endTime")) {
                throw new RuntimeException("\u83b7\u53d6\u8f68\u8ff9\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4!");
            }
            condition = condition + " and f_realtime >= '" + jo.getString("beginTime") + "' and f_realtime <= '" + jo.getString("endTime") + "'";
            if (jo.isNull("patrolId")) {
                throw new RuntimeException("\u83b7\u53d6\u8f68\u8ff9\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\u4eba\u5458ID!");
            }
            condition = condition + " and f_user_id ='" + jo.getString("patrolId") + "' ";
            JSONArray array = this.sqlServer.query("select * from t_phone_state where " + condition + " order by f_realtime");
            JSONObject item = null;
            JSONObject row = null;
            JSONArray data = new JSONArray();
            for (int i = 0; i < array.length(); ++i) {
                item = array.getJSONObject(i);
                row = new JSONObject();
                row.put("accuracy", 0);
                row.put("reportTime", (Object)item.getString("f_realtime"));
                row.put("name", (Object)item.getString("f_user_name"));
                row.put("latitude", (Object)item.getString("f_longitude"));
                row.put("longitude", (Object)item.getString("f_latitude"));
                if (item.isNull("f_speed")) {
                    row.put("speed", 0);
                } else {
                    row.put("speed", (Object)item.getString("f_speed"));
                }
                data.put((Object)row);
            }
            result.put("data", (Object)data);
            result.put("success", true);
            log.debug((Object)("\u83b7\u53d6\u8f68\u8ff9\u4fe1\u606f\u6210\u529f,\u6570\u636e:" + array.toString()));
        }
        catch (Exception e) {
            log.debug((Object)("\u83b7\u53d6\u8f68\u8ff9\u4fe1\u606f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f=>" + e.getMessage()));
            result.put("success", false);
            result.put("msg", (Object)e.getMessage());
        }
        log.debug((Object)("\u83b7\u53d6\u8f68\u8ff9\u4fe1\u606f\u6210\u529f\uff0c\u8fd4\u56de\u6570\u636e:" + result.toString()));
        return result.toString();
    }

    public int checkOnLine(String time) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = format.parse(time);
        long millisecond = date.getTime();
        if (System.currentTimeMillis() - millisecond < 360000L) {
            return 2;
        }
        return 5;
    }
}

