SELECT

	a.f_residential_area,    --小区
	a.f_area,
  a.f_slice_area,
  a.f_street,
	a.f_user_type, --用户类型
	a.f_table_state,
    max(a.f_last_check_date) f_last_check_date, --最后安检时间
	count(a.f_userinfo_id) f_user_num  --用户数
 FROM (select
	ui.f_userinfo_id,
	ui.f_userinfo_code,
	{
	month != $$ :
	$
	1 code,
	$,
	$$
	}
	ui.f_user_name,
	ui.f_user_phone,
	ui.f_user_type,
	ui.f_last_check_date,
	ui.f_last_check_result,
  ui.f_comments,
	ui.version,
	uf.f_table_state,
	ui.f_filiale,
		tua.f_address,
		tua.f_residential_area,
		tua.f_pcd f_area ,
		tua.f_street,
		tua.f_slice_area
 from t_userinfo ui left join t_user_address tua
 on ui.f_userinfo_id=tua.f_userinfo_id
 left join t_userfiles uf
 on u.f_userinfo_id = uf.f_userinfo_id
where {condition} and ui.f_userinfo_id is not null  And ui.f_user_type = '民用'
{
	month != $$ :
	(
		 entity.findDialect()==$SqlServer$:
		 $AND datediff(month,ui.f_last_check_date,getdate()) >={ month }$,
         $AND months_between(sysdate ,ui.f_last_check_date)>={ month }$
     ),
	month == $$ :
	$
  and	1=1
	$,
	$$
}
{
	f_table_state != $$ :
	$
	  and uf.f_table_state = '{f_table_state}'
	$,
	f_table_state == $$ :
	$
  and	1=1
	$,
	$$
}
{
	SafeCheckSX.f_check_start != $$ &&  SafeCheckSX.f_check_end != $$ && SafeCheckCQ == $$ :
	   (
             entity.findDialect()==$SqlServer$:
             $ 	and  ( isnull(ui.f_last_check_date,ui.f_createfile_date) <= '{SafeCheckSX.f_check_start}' or isnull(ui.f_last_check_date,ui.f_createfile_date) >= '{SafeCheckSX.f_check_end}' or isnull(ui.f_last_check_date,ui.f_createfile_date) is null )$,
             $ 	and  ( nvl(ui.f_last_check_date,ui.f_createfile_date) <= '{SafeCheckSX.f_check_start}' or nvl(ui.f_last_check_date,ui.f_createfile_date) >= '{SafeCheckSX.f_check_end}' or nvl(ui.f_last_check_date,ui.f_createfile_date) is null )$
         ),
  SafeCheckSX.f_check_start != $$ &&  SafeCheckSX.f_check_end != $$ && SafeCheckCQ == $是$ :
   (
             entity.findDialect()==$SqlServer$:
             $ 	 and  ( isnull(ui.f_last_check_date,ui.f_createfile_date) <= '{SafeCheckSX.f_check_start}' or isnull(ui.f_last_check_date,ui.f_createfile_date) >= '{SafeCheckSX.f_check_end}' or isnull(ui.f_last_check_date,ui.f_createfile_date) is null )
                 and  ( DATEADD(month,{safeCycle},isnull(ui.f_last_check_date,ui.f_createfile_date)) <= GETDATE())$,
             $  and  ( nvl(ui.f_last_check_date,ui.f_createfile_date) <= '{SafeCheckSX.f_check_start}' or nvl(ui.f_last_check_date,ui.f_createfile_date) >= '{SafeCheckSX.f_check_end}' or nvl(ui.f_last_check_date,ui.f_createfile_date) is null )
                and  ( add_months(nvl(ui.f_last_check_date,ui.f_createfile_date),{safeCycle}) <=sysdate)$
         ),
  SafeCheckSX.f_check_start != $$ &&  SafeCheckSX.f_check_end != $$ && SafeCheckCQ == $否$ :
    (
             entity.findDialect()==$SqlServer$:
             $ 	and  ( isnull(ui.f_last_check_date,ui.f_createfile_date) <= '{SafeCheckSX.f_check_start}' or isnull(ui.f_last_check_date,ui.f_createfile_date) >= '{SafeCheckSX.f_check_end}' or isnull(ui.f_last_check_date,ui.f_createfile_date) is null )
                and ( DATEADD(month,{safeCycle},isnull(ui.f_last_check_date,ui.f_createfile_date)) >= GETDATE())$,
             $  and  ( nvl(ui.f_last_check_date,ui.f_createfile_date) <= '{SafeCheckSX.f_check_start}' or nvl(ui.f_last_check_date,ui.f_createfile_date) >= '{SafeCheckSX.f_check_end}' or nvl(ui.f_last_check_date,ui.f_createfile_date) is null )
               and ( add_months(nvl(ui.f_last_check_date,ui.f_createfile_date),{safeCycle}) >= sysdate)$
         ),
	SafeCheckSX.f_check_start == $$ && SafeCheckSX.f_check_end != $$ && SafeCheckSC == $$:
	 (
             entity.findDialect()==$SqlServer$:
             $  and	 (isnull(ui.f_last_check_date,ui.f_createfile_date) >= '{SafeCheckSX.f_check_end}' or isnull(ui.f_last_check_date,ui.f_createfile_date) is null)$,
             $  and (nvl(ui.f_last_check_date,ui.f_createfile_date) >= '{SafeCheckSX.f_check_end}' or nvl(ui.f_last_check_date,ui.f_createfile_date) is null)$
         ),
		SafeCheckSX.f_check_start != $$ && SafeCheckSX.f_check_end == $$ && SafeCheckSC == $$:
			 (
             entity.findDialect()==$SqlServer$:
             $ and	 (isnull(ui.f_last_check_date,ui.f_createfile_date) <= '{SafeCheckSX.f_check_start}' or isnull(ui.f_last_check_date,ui.f_createfile_date) is null)$,
             $ and	 (nvl(ui.f_last_check_date,ui.f_createfile_date) <= '{SafeCheckSX.f_check_start}' or nvl(ui.f_last_check_date,ui.f_createfile_date) is null)$
             ),
	$$
}
{
	SafeCheckSX.f_check_start != $$  && SafeCheckSC == $是$:
	$
	and  ui.f_issued_time >= '{SafeCheckSX.f_check_start}'
	$,
	SafeCheckSX.f_check_start == $$ && SafeCheckSC == $是$:
	$
	and  1 = 1
	$,
	$$
}
{
	SafeCheckSX.f_check_end != $$ && SafeCheckSC == $是$:
	$
	and  ui.f_issued_time <= '{SafeCheckSX.f_check_end}'
	$,
	SafeCheckSX.f_check_end == $$ && SafeCheckSC == $是$:
	$
	and  1 = 1
	$,
	$$
}
{
	SafeCheckSX.f_check_start != $$ && SafeCheckSX.f_check_end != $$  && SafeCheckSC == $否$:
	$
	and  ( ui.f_issued_time < '{SafeCheckSX.f_check_start}' or ui.f_issued_time > '{SafeCheckSX.f_check_end}' or ui.f_issued_time is null )
	$,
	SafeCheckSX.f_check_start == $$ && SafeCheckSX.f_check_end != $$  && SafeCheckSC == $否$:
	$
	and ( ui.f_issued_time > '{SafeCheckSX.f_check_end}' or ui.f_issued_time is null )
	$,
	SafeCheckSX.f_check_start != $$ && SafeCheckSX.f_check_end == $$  && SafeCheckSC == $否$:
	$
	and  ( ui.f_issued_time < '{SafeCheckSX.f_check_start}' or ui.f_issued_time is null )
	$,
	$$
}

) a
GROUP BY 	f_residential_area,    --小区
	f_user_type,
	uf.f_tabel_state,
	f_street,
	f_area,
  f_slice_area
order by {orderitem}