SELECT
	a.f_residential_area,    --小区
	a.f_area,
  a.f_street,
	case when a.f_special is null then '民用' else null end  f_user_type, --用户类型
	f_userinfo_id,
	f_user_name,
	f_last_check_date,
	f_address,
	f_card_id,
	f_level_one_discover_time,
	add_months(to_date(f_level_one_discover_time,'yyyy-mm-dd hh24:mi:ss'),{overDue}) overdate
FROM
	(
	SELECT
		ui.f_userinfo_id,
		ui.f_user_name,
		ui.f_last_check_date,
		tua.f_residential_area,
		tua.f_pcd as f_area,
		tua.f_special,
		tua.f_street,
		tua.f_address,
		uf.f_card_id,
		ui.f_level_one_discover_time
	FROM
		(select * from T_USERINFO where f_iskeyuser='是')	 ui left join t_user_address tua  on ui.f_userinfo_id=tua.f_userinfo_id
		left join t_userfiles uf
    on ui.f_userinfo_id = uf.f_userinfo_id
		left join
		(select * from
			(select
				 F_USERINFOID,
				 F_CREATE_TIME,
				 F_LAST_CHECK_STATE,
				 f_upload_state,
				 f_state,
				 ROW_NUMBER() over(partition by F_USERINFOID order by F_CREATE_TIME DESC) lastday
			 from T_CHECK_PLAN_item  where F_NO_CHECKPLAN = '一级隐患跟进单'
			)t where lastday =1
		) cpi on CPI.f_userinfoid = ui.f_userinfo_id
	WHERE
		{ condition }
		--地址f_special null 为空 非民用档案
		AND ui.f_userinfo_id IS NOT NULL 	And tua.f_special is null
    and (ui.f_level_one_discover_time >=NVL(F_CREATE_TIME,to_date('1924-02-05 00:00:00','yyyy-mm-dd hh24:mi:ss'))    --发现隐患后没有生成过计划
				 or (ui.f_level_one_discover_time <= CPI.F_CREATE_TIME and CPI.f_state = '已检' and CPI.f_upload_state = '已传' and CPI.f_last_check_state = '到访不遇')      --或者发现隐患后生成计划  但是上传的单子为到访不遇
		)
		{ month != $$ :(
		 entity.findDialect()==$SqlServer$:
		 $AND datediff(month,ui.f_last_check_date,getdate()) >={ month }$,
         $AND months_between(sysdate ,ui.f_last_check_date)>={ month }$
    )
		,
		month == $$ :
		$
		AND 1 = 1 $,
		$$
		}

	) a
ORDER BY
	f_level_one_discover_time,
	f_residential_area

