SELECT
	tu.F_EMPHASIS_USER,
	F_RESIDENTIAL_AREA,
	F_USER_PHONE,
	F_CARD_ID,
	t.F_BUILDING,
	fe,
	F_ONSITE_TIME,
	sa.f_item_value bj,
	F_REMARKS,
CASE

		WHEN sa1.f_item_value = '开放式厨房' THEN
		'是' ELSE '否'
	END AS kf,
CASE

		WHEN sa1.f_item_value = '密闭式厨房' THEN
		'是' ELSE '否'
	END AS fb,
CASE

		WHEN sa2.f_item_value = '金属软管' THEN
		'是' ELSE '否'
	END AS js,
	CASE

		WHEN sa4.f_item_value = '合格' THEN
		'是' ELSE '否'
	END AS hege,
	CASE

		WHEN bbb > 0 THEN
		'是' ELSE '否'
	END AS lq
FROM
	(
	SELECT
		id,
		F_USERINFOID,
		F_USER_EQUIPMEN,
		F_BUILDING,
		f_user_equipmen AS fe,
		F_ONSITE_TIME,
		F_REMARKS,
		ROW_NUMBER ( ) OVER ( PARTITION BY f_userinfoid ORDER BY f_onsite_time DESC ) rn
	FROM
		t_check_paper
	WHERE
		1 = 1
	) t
	LEFT JOIN T_USERINFO tu ON t.F_USERINFOID = tu.F_USERINFO_ID
	LEFT JOIN T_USER_ADDRESS td ON td.f_userinfo_id = tu.F_USERINFO_ID
	LEFT JOIN T_USERFILES tf ON tf.f_userinfo_id = td.f_userinfo_id
	LEFT JOIN (
	SELECT
		pd.F_PAPER_ID,
		F_ITEM_value
	FROM
		T_PAPER_DEVICES pd
		LEFT JOIN T_DEVICES_ITEMS di ON pd.id = di.F_DEVICE_ID
		LEFT JOIN T_DEVICES_ITEMS_LISTS dil ON di.id = dil.F_ITEM_ID
	WHERE
		f_device_type = '报警器'
		AND F_ITEM_NAME = '有否'
	) sa ON t.id = sa.F_PAPER_ID
	LEFT JOIN (
	SELECT
		pd.F_PAPER_ID,
		F_ITEM_value
	FROM
		T_PAPER_DEVICES pd
		LEFT JOIN T_DEVICES_ITEMS di ON pd.id = di.F_DEVICE_ID
		LEFT JOIN T_DEVICES_ITEMS_LISTS dil ON di.id = dil.F_ITEM_ID
	WHERE
		f_device_type = '其他'
		AND F_ITEM_NAME = '其他'
	) sa1 ON t.id = sa1.F_PAPER_ID
	LEFT JOIN (
	SELECT
		pd.F_PAPER_ID,
		F_ITEM_value
	FROM
		T_PAPER_DEVICES pd
		LEFT JOIN T_DEVICES_ITEMS di ON pd.id = di.F_DEVICE_ID
		LEFT JOIN T_DEVICES_ITEMS_LISTS dil ON di.id = dil.F_ITEM_ID
	WHERE
		f_device_type = '灶具连接管'
		AND F_ITEM_NAME = '灶具连接管安装类型'
	) sa2 ON t.id = sa2.F_PAPER_ID
	LEFT JOIN (
	SELECT
		count( pd.F_PAPER_ID ) AS bbb,
		pd.F_PAPER_ID
	FROM
		T_PAPER_DEVICES pd
		LEFT JOIN T_DEVICES_ITEMS di ON pd.id = di.F_DEVICE_ID
		LEFT JOIN T_DEVICES_ITEMS_LISTS dil ON di.id = dil.F_ITEM_ID
	WHERE
		( f_device_type = '电磁伐接口漏气' AND F_ITEM_NAME = '是' )
		OR F_ITEM_NAME LIKE '%漏气%'
	GROUP BY
		pd.F_PAPER_ID
	) sa3 ON t.id = sa3.F_PAPER_ID
	LEFT JOIN (
	SELECT
		pd.F_PAPER_ID,
		F_ITEM_value
	FROM
		T_PAPER_DEVICES pd
		LEFT JOIN T_DEVICES_ITEMS di ON pd.id = di.F_DEVICE_ID
		LEFT JOIN T_DEVICES_ITEMS_LISTS dil ON di.id = dil.F_ITEM_ID
	WHERE
		F_ITEM_value = '合格'
	) sa4 ON t.id = sa4.F_PAPER_ID
WHERE
	rn = 1
	AND F_EMPHASIS_USER = '小区大锅灶'
	and {condition}
order by 1
