/*
 * Decompiled with CFR 0.152.
 */
package com.aote.sql;

import com.aote.sql.SqlMapper;
import com.aote.util.ExpressionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.ResourceHelper;
import com.aote.util.SqlHelper;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SqlServer {
    static Logger log = Logger.getLogger(SqlServer.class);
    @Autowired
    public SessionFactory sessionFactory;
    public Session assignedSession;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setAssignedSession(Session session) {
        this.assignedSession = session;
    }

    public JSONObject queryTotal(String name, String str) throws Exception {
        JSONObject param = null;
        Object sums = null;
        if (str != null && !str.isEmpty()) {
            JSONObject json = new JSONObject(str);
            if (json.has("data")) {
                param = json.getJSONObject("data");
            }
            if (json.has("sums")) {
                sums = json.get("sums");
            }
        }
        Map<String, Object> params = JsonHelper.toMap(param);
        String sql = this.call(name, params);
        sql = this.filterOutOrderBy(sql, sums);
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = SqlHelper.query(session, sql);
        return array.getJSONObject(0);
    }

    public JSONObject queryHqlTotal(String name, String str) throws Exception {
        JSONObject json;
        JSONObject param = null;
        if (str != null && !str.isEmpty() && (json = new JSONObject(str)).has("data")) {
            param = json.getJSONObject("data");
        }
        Map<String, Object> params = JsonHelper.toMap(param);
        String sql = this.call(name, params);
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = SqlHelper.hqlQuery(session, sql);
        return array.getJSONObject(0);
    }

    public JSONArray query(String name, String str) throws Exception {
        return this.query(name, 1, 1000, str);
    }

    public JSONArray query(String name, String str, Integer pageSize) throws Exception {
        return pageSize <= 0 ? this.query(name, 1, 9999999, str) : this.query(name, 1, (int)pageSize, str);
    }

    public JSONArray query(String name, JSONObject params) throws Exception {
        Map<String, Object> map = JsonHelper.toMap(params);
        return this.query(name, 1, 1000, map);
    }

    public JSONArray query(String name, JSONObject params, Integer pageSize) throws Exception {
        Map<String, Object> map = JsonHelper.toMap(params);
        return pageSize <= 0 ? this.query(name, 1, 9999999, map) : this.query(name, 1, (int)pageSize, map);
    }

    public JSONArray query(String name, Map<String, Object> params) throws Exception {
        return this.query(name, 1, 1000, params);
    }

    public JSONArray query(String name, Map<String, Object> params, Integer pageSize) throws Exception {
        return pageSize <= 0 ? this.query(name, 1, 9999999, params) : this.query(name, 1, (int)pageSize, params);
    }

    public JSONArray query(String name, int pageNo, int pageSize, String str) throws Exception {
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 1000;
        }
        JSONObject param = null;
        if (str != null && !str.isEmpty()) {
            param = new JSONObject(str);
            param = param.getJSONObject("data");
        }
        Map<String, Object> params = JsonHelper.toMap(param);
        return this.query(name, pageNo, pageSize, params);
    }

    public JSONArray query(String name, int pageNo, int pageSize, Map<String, Object> params) throws Exception {
        String sql = this.call(name, params);
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = SqlHelper.query(session, sql, pageNo - 1, pageSize);
        log.debug((Object)array.toString());
        return array;
    }

    public JSONArray query(String sql) throws Exception {
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = SqlHelper.query(session, sql);
        log.debug((Object)array.toString());
        return array;
    }

    public void run(String sql) {
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        SqlHelper.bulkUpdate(session, sql);
    }

    public int runSQL(String sql) {
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        return SqlHelper.bulkSQLUpdate(session, sql);
    }

    public String call(String sqlName, JSONObject json) throws Exception {
        Map<String, Object> param = JsonHelper.toMap(json);
        return this.call(sqlName, param);
    }

    public String call(String sqlName, Map<String, Object> params) {
        String path = SqlMapper.getSql(sqlName);
        String sql = ResourceHelper.getString(path);
        sql = sql.replace("\r\n", "\n");
        sql = "$" + sql;
        params.put("sql", this);
        sql = ExpressionHelper.run(sql, params).toString();
        return sql;
    }

    public JSONArray hqlQuery(String name, JSONObject params) throws Exception {
        Map<String, Object> map = JsonHelper.toMap(params);
        String sql = this.call(name, map);
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = SqlHelper.hqlQuery(session, sql);
        return array;
    }

    public JSONArray hqlQuery(String hql) throws Exception {
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = SqlHelper.hqlQuery(session, hql);
        return array;
    }

    public JSONArray hqlQuery(String name, int pageNo, int pageSize, String str) throws Exception {
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize < 1 || pageSize > 1000) {
            pageSize = 1000;
        }
        JSONObject param = null;
        if (str != null && !str.isEmpty()) {
            param = new JSONObject(str);
            param = param.getJSONObject("data");
        }
        Map<String, Object> params = JsonHelper.toMap(param);
        return this.hqlQuery(name, pageNo, pageSize, params);
    }

    public JSONArray hqlQuery(String name, int pageNo, int pageSize, Map<String, Object> params) throws Exception {
        String sql = this.call(name, params);
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = SqlHelper.hqlQuery(session, sql, pageNo - 1, pageSize);
        log.debug((Object)array.toString());
        return array;
    }

    private String filterOutOrderBy(String source, Object sums) throws Exception {
        int idx = source.toLowerCase().lastIndexOf("order by");
        String sql = "select ";
        if (sums != null) {
            if (sums instanceof JSONArray) {
                JSONArray arraySums = (JSONArray)sums;
                for (int i = 0; i < arraySums.length(); ++i) {
                    String name = (String)arraySums.get(i);
                    sql = sql + "sum(" + name + ") " + name + ", ";
                }
            } else if (sums instanceof JSONObject) {
                JSONObject objSums = (JSONObject)sums;
                Iterator keys = objSums.keys();
                while (keys.hasNext()) {
                    String name = (String)keys.next();
                    String value = objSums.getString(name);
                    sql = sql + "sum(" + value + ") " + name + ", ";
                }
            }
        }
        if (idx != -1) {
            sql = sql + "count(*) n, 1 placeholder from ( " + source.substring(0, idx) + ") t_";
        }
        return sql;
    }

    public JSONObject action(JSONObject params) {
        System.out.println(params.toString());
        JSONObject result = new JSONObject("{code: 200, data: {}}");
        return result;
    }
}

