/*
 * Decompiled with CFR 0.152.
 */
package com.aote.path;

import com.aote.path.PathHelper;
import com.aote.path.PathMapper;
import com.aote.util.ExpressionHelper;
import com.aote.util.JsonHelper;
import com.aote.util.ResourceHelper;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PathServer {
    static Logger log = Logger.getLogger(PathServer.class);
    @Autowired
    public SessionFactory sessionFactory;
    public Session assignedSession;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setAssignedSession(Session session) {
        this.assignedSession = session;
    }

    public JSONArray query(String name, String str) {
        try {
            JSONObject json;
            JSONObject param = null;
            if (str != null && !str.isEmpty() && (json = new JSONObject(str)).has("data")) {
                param = json.getJSONObject("data");
            }
            Map<String, Object> params = JsonHelper.toMap(param);
            String path = this.call(name, params);
            Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
            JSONArray array = PathHelper.query(session, path);
            return array;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JSONObject queryTotal(String name, String str) throws Exception {
        JSONObject json;
        JSONObject param = null;
        if (str != null && !str.isEmpty() && (json = new JSONObject(str)).has("data")) {
            param = json.getJSONObject("data");
        }
        Map<String, Object> params = JsonHelper.toMap(param);
        String path = this.call(name, params);
        path = this.filterOutOrderBy(path);
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = PathHelper.query(session, path);
        return array.getJSONObject(0);
    }

    public JSONArray query(String name, int pageNo, int pageSize, String str) throws Exception {
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 1000;
        }
        JSONObject param = null;
        if (str != null && !str.isEmpty()) {
            param = new JSONObject(str);
            param = param.getJSONObject("data");
        }
        Map<String, Object> params = JsonHelper.toMap(param);
        return this.query(name, pageNo, pageSize, params);
    }

    public JSONArray query(String name, int pageNo, int pageSize, Map<String, Object> params) throws Exception {
        String sql = this.call(name, params);
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        JSONArray array = PathHelper.query(session, sql, pageNo - 1, pageSize);
        log.debug((Object)array.toString());
        return array;
    }

    public String call(String name, Map<String, Object> params) {
        String path = PathMapper.getPath(name);
        String sql = ResourceHelper.getString(path);
        sql = sql.replace("\r\n", "\n");
        sql = "$" + sql;
        params.put("sql", this);
        sql = ExpressionHelper.run(sql, params).toString();
        return sql;
    }

    private String filterOutOrderBy(String source) {
        BufferedReader reader = new BufferedReader(new StringReader(source));
        try {
            String line = reader.readLine();
            reader.close();
            int index = line.lastIndexOf(46);
            String result = line.substring(0, index) + ".(count(*) n, group(null))";
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JSONArray query(String sql) {
        Session session = this.assignedSession == null ? this.sessionFactory.getCurrentSession() : this.assignedSession;
        try {
            return PathHelper.query(session, sql);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

