/*
 * Decompiled with CFR 0.152.
 */
package com.aote.logic;

import com.aote.entity.EntityServer;
import com.aote.logic.LogicMapper;
import com.aote.logic.PluginMapper;
import com.aote.path.PathServer;
import com.aote.sql.SqlServer;
import com.aote.util.ExpressionHelper;
import com.aote.util.ResourceHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogicServer {
    static Logger log = Logger.getLogger(LogicServer.class);
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private PathServer pathServer;
    @Autowired
    public SessionFactory sessionFactory;
    private JSONObject context = null;

    public Object run(String name, String str) throws Exception {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                param = new JSONObject(str);
                if (!param.isNull("context")) {
                    this.context = param.getJSONObject("context");
                }
                if (!param.isNull("data")) {
                    param = param.getJSONObject("data");
                }
            } else if (json instanceof JSONArray) {
                param = new JSONObject();
                param.put("arr", (Object)new JSONArray(str));
            }
        }
        return this.run(name, param, this.context);
    }

    public Object run(String name, JSONObject param, JSONObject context) throws Exception {
        String path = LogicMapper.getLogic(name);
        if (path == null) {
            return new RuntimeException("\u4e1a\u52a1\u903b\u8f91\u672a\u627e\u5230: " + name);
        }
        String source = ResourceHelper.getString(path);
        source = source.replace("\r\n", "\n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", param);
        if (context != null) {
            params.put("context", context);
        }
        params.put("log", this);
        params.put("entity", this.entityServer);
        params.put("sql", this.sqlServer);
        params.put("path", this.pathServer);
        params.put("logic", this);
        Map<String, Object> plugins = PluginMapper.getPlugins();
        for (String key : plugins.keySet()) {
            params.put(key, plugins.get(key));
        }
        Object result = ExpressionHelper.run(source, params);
        return result;
    }

    public Object run(String name, JSONObject param) throws Exception {
        return this.run(name, param, this.context);
    }

    public Object noTranscRun(String name, String str) throws Exception {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                param = new JSONObject(str);
                if (!param.isNull("data")) {
                    param = param.getJSONObject("data");
                }
            } else if (json instanceof JSONArray) {
                param = new JSONObject();
                param.put("arr", (Object)new JSONArray(str));
            }
        }
        return this.noTranscRun(name, param);
    }

    public Object noTranscRun(String name, JSONObject param) throws Exception {
        String path = LogicMapper.getLogic(name);
        String source = ResourceHelper.getString("/logics/" + path);
        source = source.replace("\r\n", "\n");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", param);
        params.put("log", log);
        params.put("entity", this.entityServer);
        SqlServer sqlServer = new SqlServer();
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            sqlServer.setAssignedSession(session);
            params.put("sql", sqlServer);
            params.put("session", session);
            params.put("logic", this);
            Map<String, Object> plugins = PluginMapper.getPlugins();
            for (String key : plugins.keySet()) {
                params.put(key, plugins.get(key));
            }
            Object result = new Object();
            Object object = result = ExpressionHelper.run(source, params);
            return object;
        }
    }

    public void debug(Object msg) {
        log.debug(msg);
    }

    public void debug(String logic, Object msg) {
        String level = LogicMapper.getAttr(logic, "log");
        if (level != null) {
            log.debug((Object)(logic + ":" + msg));
        }
    }
}

