/*
 * Decompiled with CFR 0.152.
 */
package com.aote.entity;

import com.af.util.Pair;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlMapper;
import com.aote.util.JsonHelper;
import com.aote.util.SqlHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.Assigned;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.id.GUIDGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.internal.SessionImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class EntityServer {
    private static final String DIALECT_SQLSERVER = "SqlServer";
    private static final String DIALECT_ORACLE = "Oracle";
    private static final String COL_STRING = "STRING";
    private static final String COL_DATE = "DATE";
    private static final String COL_TIME = "TIME";
    private static final String COL_BOOLEAN = "BOOLEAN";
    private static final String COL_NUMBER = "NUMBER";
    private static final String COL_NOTSUPPORTED = "NOT_SUPPORTED";
    private static final String ID_GUID = "ID_GUID";
    private static final String ID_SEQ = "ID_SEQ";
    private static final String ID_AUTO = "ID_AUTO";
    private static final String ID_ASSIGNED = "ID_ASSIGNED";
    private static final String ID_FOREIGNER = "ID_FOREIGNER";
    public static HashMap<String, HashMap<String, Object>> metaMap = new HashMap();
    public static HashMap<String, String> entityLiftMap = new HashMap();
    static Logger log = Logger.getLogger(EntityServer.class);
    @Autowired
    public SessionFactory sessionFactory;

    public String save(String entityName, String values) throws Exception {
        Session session = this.sessionFactory.getCurrentSession();
        JSONObject object = new JSONObject(values);
        JSONObject data = object.getJSONObject("data");
        Map<String, Object> map = JsonHelper.toMap(data, entityName, this.sessionFactory);
        JSONObject result = this.save(session, entityName, map);
        return result.toString();
    }

    public String save(String entityName, Map<String, Object> map) throws Exception {
        Session session = this.sessionFactory.getCurrentSession();
        Map<String, Object> data = JsonHelper.toMap(map, entityName, this.sessionFactory);
        JSONObject result = this.save(session, entityName, data);
        return result.toString();
    }

    public Object save(String entityName, JSONObject json) throws Exception {
        Session session = this.sessionFactory.getCurrentSession();
        Map<String, Object> data = JsonHelper.toMap(json, entityName, this.sessionFactory);
        JSONObject result = this.save(session, entityName, data);
        Object o = result.get("id");
        return o;
    }

    public String delete(String entityName, String id) throws Exception {
        HashMap<String, Object> map = metaMap.get(entityName);
        String hql = "delete from " + map.get("tableName") + " where " + map.get("idName") + "=" + this.normalizeValue(this.findDialect(), id, (String)map.get("idType"));
        SqlHelper.bulkSQLUpdate(this.sessionFactory.getCurrentSession(), hql);
        return "ok";
    }

    private JSONObject save(Session session, String entityName, Map<String, Object> map) {
        JSONObject result = new JSONObject();
        Serializable id = null;
        if (map.containsKey("id")) {
            session.update(entityName, map);
            id = (Serializable)map.get("id");
        } else {
            id = session.save(entityName, map);
        }
        session.flush();
        result.put("id", (Object)id);
        return result;
    }

    private String findDialect() throws Exception {
        SessionFactoryImplementor sf = (SessionFactoryImplementor)this.sessionFactory;
        String dialect = sf.getDialect().toString().toLowerCase();
        if (dialect.contains("sqlserver")) {
            return DIALECT_SQLSERVER;
        }
        if (dialect.contains("oracle")) {
            return DIALECT_ORACLE;
        }
        throw new Exception("\u6570\u636e\u5e93\u65b9\u8a00\u914d\u7f6e\u5f02\u5e38\u3002");
    }

    private String normalizeType(String type) {
        if ((type = type.toLowerCase()).equals("string")) {
            return COL_STRING;
        }
        if (type.equals("date")) {
            return COL_DATE;
        }
        if (type.equals("time") || type.equals("timestamp")) {
            return COL_TIME;
        }
        if (type.equals("boolean") || type.equals("yes_no")) {
            return COL_BOOLEAN;
        }
        if (type.equals("integer") || type.equals("double") || type.equals("big_decimal") || type.equals("big_integer")) {
            return COL_NUMBER;
        }
        return COL_NOTSUPPORTED;
    }

    private HashMap<String, Object> getMetaData(String entityName) throws Exception {
        if (metaMap.containsKey(entityName)) {
            return metaMap.get(entityName);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entityName", entityName);
        ClassMetadata cmd = this.sessionFactory.getClassMetadata(entityName);
        AbstractEntityPersister aep = (AbstractEntityPersister)cmd;
        map.put("tableName", aep.getTableName());
        String attr = cmd.getIdentifierPropertyName();
        map.put("idName", attr);
        map.put("idColName", aep.getPropertyColumnNames(attr)[0]);
        String idType = this.normalizeType(cmd.getIdentifierType().getName());
        map.put("idType", idType);
        IdentifierGenerator idg = aep.getIdentifierGenerator();
        if (idg instanceof GUIDGenerator || idg instanceof UUIDGenerator || idg instanceof UUIDHexGenerator) {
            map.put("idGenerator", ID_GUID);
        } else if (idg instanceof SequenceGenerator) {
            map.put("sequence", ((SequenceGenerator)idg).getSequenceName());
            map.put("idGenerator", ID_SEQ);
        } else if (idg instanceof IdentityGenerator) {
            map.put("idGenerator", ID_AUTO);
        } else if (idg instanceof Assigned) {
            map.put("idGenerator", ID_ASSIGNED);
        } else if (idg instanceof ForeignGenerator) {
            map.put("idGenerator", ID_FOREIGNER);
        } else {
            throw new Exception("Unsupported id generator strategy:" + idg.getClass().getName());
        }
        if (cmd.isVersioned()) {
            attr = cmd.getPropertyNames()[cmd.getVersionProperty()];
            map.put("verName", attr);
            map.put("verColName", aep.getPropertyColumnNames(attr)[0]);
            map.put("verType", this.normalizeType(cmd.getPropertyType(attr).getName()));
        }
        HashMap<String, Pair> columns = new HashMap<String, Pair>();
        map.put("columns", columns);
        HashMap<String, Pair> links = new HashMap<String, Pair>();
        map.put("links", links);
        HashMap<String, Pair> onetoone = new HashMap<String, Pair>();
        map.put("onetoone", onetoone);
        HashMap<String, Pair> onetomany = new HashMap<String, Pair>();
        map.put("onetomany", onetomany);
        for (String property : cmd.getPropertyNames()) {
            Type type = cmd.getPropertyType(property);
            log.debug((Object)("property: " + property + "," + type.getClass().getName()));
            if (type instanceof CollectionType || type instanceof OneToOneType) {
                String link;
                String linkEntity;
                Joinable ja;
                CollectionType st;
                SessionFactoryImplementor sf = (SessionFactoryImplementor)this.sessionFactory;
                if (type instanceof CollectionType) {
                    st = (CollectionType)type;
                    ja = st.getAssociatedJoinable(sf);
                    linkEntity = st.getAssociatedEntityName(sf);
                } else {
                    st = (OneToOneType)type;
                    ja = st.getAssociatedJoinable(sf);
                    linkEntity = st.getAssociatedEntityName(sf);
                    log.debug((Object)("one-to-one direction: " + st.getForeignKeyDirection()));
                }
                String foreignkey = ja.getKeyColumnNames()[0];
                if (type instanceof OneToOneType) {
                    link = property;
                } else {
                    HashMap pkfk;
                    link = ja.getName().substring(entityName.length() + 1);
                    HashMap<String, Object> linkedMap = linkEntity.equals(entityName) ? map : this.getMetaData(linkEntity);
                    if (linkedMap.containsKey("associations")) {
                        pkfk = (HashMap)linkedMap.get("associations");
                        pkfk.put(entityName, new Pair(foreignkey, idType));
                    } else {
                        pkfk = new HashMap();
                        pkfk.put(entityName, new Pair(foreignkey, idType));
                        linkedMap.put("associations", pkfk);
                    }
                }
                links.put(link, new Pair(linkEntity, foreignkey));
                if (type instanceof CollectionType) {
                    onetomany.put(link, new Pair(linkEntity, foreignkey));
                    continue;
                }
                onetoone.put(link, new Pair(linkEntity, foreignkey));
                continue;
            }
            if (type instanceof ManyToOneType) continue;
            String columnName = ((AbstractEntityPersister)cmd).getPropertyColumnNames(property)[0];
            columns.put(property, new Pair(columnName, this.normalizeType(type.getName())));
        }
        metaMap.put(entityName, map);
        return map;
    }

    public <T extends Serializable> T deepClone(T o) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(o);
        out.flush();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
        return (T)((Serializable)o.getClass().cast(in.readObject()));
    }

    private void enchanceMetaData(HashMap<String, Object> pmd, String entityName) throws Exception {
        HashMap<String, Object> md = metaMap.get(entityName);
        HashMap links = (HashMap)md.get("links");
        HashMap plinks = (HashMap)pmd.get("links");
        for (String key : links.keySet()) {
            plinks.put(key, this.deepClone((Serializable)links.get(key)));
        }
        HashMap sub = md.containsKey("subclasses") ? (HashMap)md.get("subclasses") : new HashMap();
        HashMap psub = pmd.containsKey("subclasses") ? (HashMap)pmd.get("subclasses") : new HashMap();
        for (String key : sub.keySet()) {
            psub.put(key, this.deepClone((Serializable)sub.get(key)));
        }
        HashMap inv = (HashMap)md.get("inverses");
        HashMap pinv = (HashMap)pmd.get("inverses");
        for (String key : inv.keySet()) {
            pinv.put(key, inv.get(key));
        }
        HashMap invid = md.containsKey("inverseid") ? (HashMap)md.get("inverseid") : new HashMap();
        HashMap pinvid = pmd.containsKey("inverseid") ? (HashMap)pmd.get("inverseid") : new HashMap();
        for (String key : invid.keySet()) {
            pinvid.put(key, this.deepClone((Serializable)invid.get(key)));
        }
    }

    public String partialSave(String entityName, JSONObject row) throws Exception {
        HashMap md;
        if (entityLiftMap.containsKey(entityName)) {
            String pEntityName = entityLiftMap.get(entityName);
            md = (HashMap)this.deepClone((Serializable)metaMap.get(pEntityName));
            this.enchanceMetaData(md, entityName);
        } else {
            md = metaMap.get(entityName);
        }
        String dialect = this.findDialect();
        Serializable aid = this.partialSave(row, md, null, null, dialect);
        JSONObject result = new JSONObject();
        result.put((String)md.get("idName"), (Object)aid.toString());
        return result.toString();
    }

    public String partialSave(String entityName, String values) throws Exception {
        JSONObject row = new JSONObject(values);
        return this.partialSave(entityName, row);
    }

    private Serializable partialSave(JSONObject row, HashMap<String, Object> md, Object pIdValue, String pEntityName, String dialect) throws Exception {
        int affectedRows;
        Object idValue = null;
        String idName = (String)md.get("idName");
        String idType = (String)md.get("idType");
        if (row.has(idName)) {
            idValue = row.get(idName);
        }
        HashMap columns = (HashMap)md.get("columns");
        HashMap links = (HashMap)md.get("links");
        boolean isInsert = false;
        if (idValue == null) {
            affectedRows = this.doInsert(row, md, pIdValue, pEntityName, dialect, idName, idType, columns);
        } else if (!md.get("idGenerator").equals(ID_ASSIGNED)) {
            isInsert = false;
            affectedRows = this.doUpdate(row, md, pIdValue, pEntityName, dialect, idValue, idType, columns);
        } else if (this.hasKeyRow(dialect, (String)md.get("tableName"), (String)md.get("idColName"), idValue, idType)) {
            isInsert = false;
            affectedRows = this.doUpdate(row, md, pIdValue, pEntityName, dialect, idValue, idType, columns);
        } else {
            isInsert = true;
            affectedRows = this.doInsert(row, md, pIdValue, pEntityName, dialect, idName, idType, columns);
        }
        if (affectedRows == 0) {
            log.debug((Object)"\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u5728\u5176\u4ed6\u5730\u65b9\u53ef\u80fd\u88ab\u4fee\u6539\u3002");
            throw new WebException(505, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u5728\u5176\u4ed6\u5730\u65b9\u53ef\u80fd\u88ab\u4fee\u6539\u3002");
        }
        idValue = row.get(idName);
        if (isInsert) {
            row.remove(idName);
        }
        Iterator itr = row.keys();
        while (itr.hasNext()) {
            String attr = (String)itr.next();
            if (!links.containsKey(attr) || !row.has(attr)) continue;
            Pair pair = (Pair)links.get(attr);
            HashMap<String, Object> cmd = metaMap.get(pair.col);
            String cEntityName = (String)md.get("entityName");
            if (row.isNull(attr)) {
                if (!pair.col.equals(attr)) continue;
                this.deleteOneToOne(dialect, (String)cmd.get("tableName"), (String)cmd.get("idColName"), row.get(idName), idType);
                continue;
            }
            Object obj = row.get(attr);
            if (obj instanceof JSONArray) {
                JSONArray rows = row.getJSONArray(attr);
                for (int i = 0; i < rows.length(); ++i) {
                    this.partialSave(rows.getJSONObject(i), cmd, idValue, cEntityName, dialect);
                }
                continue;
            }
            this.partialSave((JSONObject)obj, cmd, idValue, cEntityName, dialect);
        }
        return (Serializable)idValue;
    }

    private void deleteOneToOne(String dialect, String tableName, String idCol, Object idValue, String idType) {
        String sql = "delete from " + tableName + " where " + idCol + "=" + this.normalizeValue(dialect, idValue, idType);
        log.debug((Object)("\u4e00\u5bf9\u4e00\u5220\u9664sql:" + sql));
        this.SQLUpdate(sql);
    }

    private boolean hasKeyRow(String dialect, String tableName, String idColName, Object idValue, String idType) {
        return this.sessionFactory.getCurrentSession().createSQLQuery("select 1 from " + tableName + " where " + idColName + "=" + this.normalizeValue(dialect, idValue, idType)).list().size() > 0;
    }

    private int doUpdate(JSONObject row, HashMap<String, Object> md, Object pIdValue, String pEntityName, String dialect, Object idValue, String idType, HashMap<String, Pair> columns) throws Exception {
        HashMap associations;
        Object verValue = null;
        String verName = (String)md.get("verName");
        String verType = (String)md.get("verType");
        if (verName != null && row.has(verName)) {
            verValue = row.get(verName);
        }
        StringBuilder sb = new StringBuilder();
        String foreignkey = null;
        if (pEntityName != null && (associations = (HashMap)md.get("associations")) != null && associations.containsKey(pEntityName)) {
            Pair pair = (Pair)associations.get(pEntityName);
            foreignkey = pair.col;
            sb.append(" " + foreignkey + "=" + this.normalizeValue(dialect, pIdValue, pair.type) + ", ");
        }
        if (verName != null) {
            sb.append(" " + verName + "=" + this.normalizeVer(dialect, verValue, verType) + ", ");
        }
        Iterator itr = row.keys();
        while (itr.hasNext()) {
            String attr = (String)itr.next();
            if (!columns.containsKey(attr) || attr.equals(foreignkey) || attr.equals(verName)) continue;
            Pair pair = columns.get(attr);
            sb.append(" " + pair.col + "=" + (row.isNull(attr) ? "null, " : this.normalizeValue(dialect, row.get(attr), pair.type) + ", "));
        }
        if (sb.length() == 0) {
            log.debug((Object)("\u63d0\u4ea4\u7684\u6570\u636e\u9519\u8bef\uff1a" + row.toString()));
            throw new Exception("\u63d0\u4ea4\u7684\u6570\u636e\u9519\u8bef\uff1a" + row.toString());
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.insert(0, "update " + md.get("tableName") + " set ");
        sb.append(" where " + md.get("idColName") + " = " + this.normalizeValue(dialect, idValue, idType));
        if (md.get("verName") != null) {
            sb.append(" and " + md.get("verColName") + "=" + this.normalizeValue(dialect, verValue, verType));
        }
        log.debug((Object)("\u751f\u6210\u7684\u66f4\u65b0sql: " + sb));
        int affectedRow = this.SQLUpdate(sb.toString());
        if (md.containsKey("subclasses")) {
            HashMap subclasses = (HashMap)md.get("subclasses");
            for (String sentity : subclasses.keySet()) {
                Pair p = (Pair)subclasses.get(sentity);
                if (row.isNull(p.col)) break;
                String dv = row.getString(p.col);
                if (!p.type.equals(dv) && !p.type.contains(dv + ",") && !p.type.contains("," + dv)) continue;
                StringBuffer buf = new StringBuffer();
                HashMap<String, Object> smd = metaMap.get(sentity);
                String keyAttr = (String)smd.get("idName");
                HashMap attrs = (HashMap)smd.get("columns");
                for (String attr : attrs.keySet()) {
                    if (attr.equals(keyAttr) || !row.has(attr)) continue;
                    p = (Pair)attrs.get(attr);
                    buf.append(p.col + "=" + this.normalizeValue(dialect, row.isNull(attr) ? null : row.get(attr), p.type) + ", ");
                }
                buf.delete(buf.length() - 2, buf.length());
                buf.insert(0, "update " + smd.get("tableName") + " set ");
                buf.append(" where " + smd.get("idColName") + " = " + this.normalizeValue(dialect, idValue, idType));
                log.debug((Object)("\u751f\u6210\u7684\u5b50\u66f4\u65b0sql: " + buf));
                this.SQLUpdate(buf.toString());
                HashMap links = (HashMap)smd.get("links");
                HashMap pLinks = (HashMap)md.get("links");
                Iterator itrLink = row.keys();
                while (itrLink.hasNext()) {
                    String attr = (String)itrLink.next();
                    if (pLinks.containsKey(attr) || !links.containsKey(attr) || !row.has(attr)) continue;
                    Pair pair = (Pair)links.get(attr);
                    HashMap<String, Object> cmd = metaMap.get(pair.col);
                    String cEntityName = (String)smd.get("entityName");
                    if (row.isNull(attr)) {
                        if (!pair.col.equals(attr)) continue;
                        this.deleteOneToOne(dialect, (String)cmd.get("tableName"), (String)cmd.get("idColName"), idValue, idType);
                        continue;
                    }
                    Object obj = row.get(attr);
                    if (obj instanceof JSONArray) {
                        JSONArray rows = row.getJSONArray(attr);
                        for (int i = 0; i < rows.length(); ++i) {
                            this.partialSave(rows.getJSONObject(i), cmd, idValue, cEntityName, dialect);
                        }
                        continue;
                    }
                    this.partialSave((JSONObject)obj, cmd, idValue, cEntityName, dialect);
                }
                break block1;
            }
        }
        this.handleInverses(row, md, dialect);
        return affectedRow;
    }

    private void handleInverses(JSONObject row, HashMap<String, Object> md, String dialect) throws Exception {
        HashMap inverses = (HashMap)md.get("inverses");
        for (String inverse : inverses.keySet()) {
            Object arow;
            if (row.isNull(inverse) || !((arow = row.get(inverse)) instanceof JSONObject)) continue;
            HashMap<String, Object> amd = metaMap.get(inverses.get(inverse));
            this.partialSave((JSONObject)arow, amd, null, null, dialect);
        }
    }

    private int doInsert(JSONObject row, HashMap<String, Object> md, Object pIdValue, String pEntityName, String dialect, String idName, String idType, HashMap<String, Pair> columns) throws Exception {
        String aid;
        Pair pair;
        HashMap associations;
        Object verValue = null;
        String verName = (String)md.get("verName");
        String verType = (String)md.get("verType");
        if (verName != null && row.has(verName)) {
            verValue = row.get(verName);
        }
        String idColName = (String)md.get("idColName");
        StringBuilder sbCols = new StringBuilder();
        StringBuilder sbValues = new StringBuilder();
        String foreignkey = null;
        if (pEntityName != null && (associations = (HashMap)md.get("associations")) != null) {
            for (String ass : associations.keySet()) {
                if (!ass.equals(pEntityName) && !this.hasParent(ass, pEntityName)) continue;
                pair = (Pair)associations.get(ass);
                foreignkey = pair.col;
                if (sbCols.indexOf(foreignkey + ",") != -1) continue;
                sbCols.append(foreignkey + ", ");
                sbValues.append(this.normalizeValue(dialect, pIdValue, pair.type) + ", ");
            }
        }
        if (verName != null) {
            sbCols.append(verName + ", ");
            sbValues.append(this.normalizeVer(dialect, verValue, verType) + ", ");
        }
        Iterator itr = row.keys();
        while (itr.hasNext()) {
            String attr = (String)itr.next();
            if (!columns.containsKey(attr) || attr.equals(foreignkey) || attr.equals(verName)) continue;
            Pair pair2 = columns.get(attr);
            sbCols.append(pair2.col + ", ");
            sbValues.append(row.isNull(attr) ? "null, " : this.normalizeValue(dialect, row.get(attr), pair2.type) + ", ");
        }
        String idStrategy = (String)md.get("idGenerator");
        if (idStrategy.equals(ID_GUID)) {
            sbCols.append(idColName + ", ");
            String guid = UUID.randomUUID().toString().replace("-", "");
            sbValues.append("'" + guid + "', ");
            row.put(idName, (Object)guid);
        } else if (idStrategy.equals(ID_SEQ)) {
            sbCols.append(idColName + ", ");
            aid = this.getLastSeqId((String)md.get("sequence"));
            sbValues.append(aid + ", ");
            row.put(idName, (Object)aid);
        } else if (idStrategy.equals(ID_ASSIGNED)) {
            sbCols.append(idColName + ", ");
            sbValues.append(this.normalizeValue(dialect, row.get(idName), idType) + ", ");
            row.put(idName, row.get(idName));
        } else if (idStrategy.equals(ID_FOREIGNER)) {
            sbCols.append(idColName + ", ");
            aid = this.normalizeValue(dialect, pIdValue, idType);
            sbValues.append(aid + ", ");
            row.put(idName, (Object)aid);
        }
        if (md.containsKey("inverses")) {
            HashMap inverses = (HashMap)md.get("inverses");
            HashMap inversesid = (HashMap)md.get("inverseid");
            for (String inverse : inverses.keySet()) {
                if (row.isNull(inverse)) continue;
                Object arow = row.get(inverse);
                log.debug((Object)"\u53d1\u73b0\u591a\u5bf9\u4e00\u5c5e\u6027\u8d4b\u503c:");
                if (arow instanceof JSONObject) continue;
                Pair pair3 = (Pair)inversesid.get(inverse);
                sbCols.append(pair3.col + ", ");
                sbValues.append(this.normalizeValue(dialect, arow, pair3.type) + ", ");
                log.debug((Object)("\u53d1\u73b0\u591a\u5bf9\u4e00\u5c5e\u6027\u8d4b\u503c:\u5c5e\u6027:" + pair3.col + "\uff0c\u503c\uff1a" + arow));
            }
        }
        sbCols.delete(sbCols.length() - 2, sbCols.length());
        sbCols.insert(0, "insert into " + md.get("tableName") + " (");
        sbValues.delete(sbValues.length() - 2, sbValues.length());
        sbCols.append(") values (");
        sbCols.append((CharSequence)sbValues);
        sbCols.append(")");
        log.debug((Object)("\u751f\u6210\u7684\u63d2\u5165sql\uff1b" + sbCols));
        int affectedRows = 1;
        if (idStrategy.equals(ID_AUTO)) {
            pair = this.rawJdbcUpdate(sbCols.toString());
            row.put(idName, (Object)pair.type);
            affectedRows = Integer.parseInt(pair.col);
        } else {
            affectedRows = this.SQLUpdate(sbCols.toString());
        }
        if (md.containsKey("subclasses")) {
            HashMap subclasses = (HashMap)md.get("subclasses");
            for (String sentity : subclasses.keySet()) {
                Pair p = (Pair)subclasses.get(sentity);
                if (row.isNull(p.col)) break;
                String dv = row.getString(p.col);
                if (!p.type.equals(dv) && !p.type.contains(dv + ",") && !p.type.contains("," + dv)) continue;
                StringBuffer fields = new StringBuffer();
                StringBuffer vals = new StringBuffer();
                HashMap<String, Object> smd = metaMap.get(sentity);
                String keyCol = (String)smd.get("idColName");
                fields.append(keyCol + ", ");
                vals.append(this.normalizeValue(dialect, row.get(idName), idType) + ", ");
                HashMap attrs = (HashMap)smd.get("columns");
                for (Object attr : attrs.keySet()) {
                    if (!row.has((String)attr)) continue;
                    p = (Pair)attrs.get(attr);
                    fields.append(p.col + ", ");
                    vals.append(this.normalizeValue(dialect, row.isNull(attr) ? null : row.get(attr), p.type) + ", ");
                }
                if (smd.containsKey("inverseid")) {
                    HashMap lookup = (HashMap)smd.get("inverseid");
                    for (String property : lookup.keySet()) {
                        Pair pair4;
                        if (!row.has(property) || row.isNull(property)) continue;
                        Object obj = row.get(property);
                        if (obj instanceof JSONObject) {
                            pair4 = (Pair)lookup.get(property);
                            JSONObject record = (JSONObject)obj;
                            if (!record.has(pair4.col) || record.isNull(pair4.col)) continue;
                            fields.append(pair4.col + ", ");
                            vals.append(this.normalizeValue(dialect, record.get(pair4.col), pair4.type) + ", ");
                            continue;
                        }
                        pair4 = (Pair)lookup.get(property);
                        fields.append(pair4.col + ", ");
                        vals.append(this.normalizeValue(dialect, row.get(property), pair4.type) + ", ");
                    }
                }
                foreignkey = null;
                HashMap associations2 = (HashMap)md.get("associations");
                if (associations2 != null) {
                    for (String ass : associations2.keySet()) {
                        Pair pair5 = (Pair)associations2.get(ass);
                        foreignkey = pair5.col;
                        if (!attrs.containsKey(foreignkey) || pIdValue == null || fields.indexOf(foreignkey + ", ") != -1) continue;
                        fields.append(foreignkey + ", ");
                        vals.append(this.normalizeValue(dialect, pIdValue, pair5.type) + ", ");
                    }
                }
                fields.delete(fields.length() - 2, fields.length());
                vals.delete(vals.length() - 2, vals.length());
                fields.insert(0, "insert into " + smd.get("tableName") + " (");
                fields.append(") values (");
                fields.append(vals);
                fields.append(")");
                log.debug((Object)("\u751f\u6210\u7684\u5b50\u63d2\u5165sql: " + fields));
                this.SQLUpdate(fields.toString());
                HashMap links = (HashMap)smd.get("links");
                HashMap pLinks = (HashMap)md.get("links");
                Iterator itrLink = row.keys();
                while (itrLink.hasNext()) {
                    String attr = (String)itrLink.next();
                    if (pLinks.containsKey(attr) || !links.containsKey(attr) || !row.has(attr)) continue;
                    Pair pair6 = (Pair)links.get(attr);
                    HashMap<String, Object> cmd = metaMap.get(pair6.col);
                    String cEntityName = (String)smd.get("entityName");
                    if (row.isNull(attr)) {
                        if (!pair6.col.equals(attr)) continue;
                        this.deleteOneToOne(dialect, (String)cmd.get("tableName"), (String)cmd.get("idColName"), row.get(idName), idType);
                        continue;
                    }
                    Object obj = row.get(attr);
                    if (obj instanceof JSONArray) {
                        JSONArray rows = row.getJSONArray(attr);
                        for (int i = 0; i < rows.length(); ++i) {
                            this.partialSave(rows.getJSONObject(i), cmd, row.get(idName), cEntityName, dialect);
                        }
                        continue;
                    }
                    this.partialSave((JSONObject)obj, cmd, row.get(idName), cEntityName, dialect);
                }
                break block3;
            }
        }
        this.handleInverses(row, md, dialect);
        return affectedRows;
    }

    private boolean hasParent(String entity, String pEntityName) {
        if (entityLiftMap.containsKey(entity)) {
            return true;
        }
        while (entityLiftMap.containsKey(entity)) {
            String pEntity = entityLiftMap.get(entity);
            if (pEntity.equals(pEntityName)) {
                return true;
            }
            entity = pEntity;
        }
        return false;
    }

    private Pair rawJdbcUpdate(String sql) throws Exception {
        Pair pair = new Pair("", "");
        Connection con = ((SessionImpl)this.sessionFactory.getCurrentSession()).connection();
        PreparedStatement statement = con.prepareStatement(sql, 1);
        int affectedRows = statement.executeUpdate();
        pair.col = affectedRows + "";
        if (affectedRows == 0) {
            return pair;
        }
        ResultSet rs = statement.getGeneratedKeys();
        if (!rs.next()) {
            throw new Exception("\u5f97\u5230\u63d2\u5165\u8bb0\u5f55id\u5931\u8d25\u3002");
        }
        pair.type = rs.getLong(1) + "";
        rs.close();
        statement.close();
        return pair;
    }

    private int SQLUpdate(String sql) {
        SQLQuery query = this.sessionFactory.getCurrentSession().createSQLQuery(sql);
        return query.executeUpdate();
    }

    private String query(String sql) {
        SQLQuery query = this.sessionFactory.getCurrentSession().createSQLQuery(sql);
        return query.list().get(0) + "";
    }

    private String getLastSeqId(String seq) throws Exception {
        return this.query("select " + seq + ".nextval newid from dual");
    }

    private String normalizeVer(String dialect, Object verValue, String verType) {
        if (verType.equals(COL_TIME)) {
            if (dialect.equals(DIALECT_ORACLE)) {
                return "current_timestamp";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "'" + sdf.format(new Date()) + "'";
        }
        if (verValue == null) {
            return "1";
        }
        return Integer.parseInt(verValue + "") + 1 + "";
    }

    private String normalizeValue(String dialect, Object value, String valType) {
        if (value == null) {
            return "null";
        }
        if (valType.equals(COL_STRING)) {
            return "'" + value + "'";
        }
        if (valType.equals(COL_NUMBER)) {
            return value + "";
        }
        if (valType.equals(COL_BOOLEAN)) {
            if (dialect.equals(DIALECT_ORACLE)) {
                return "'" + ((Boolean)value != false ? "Y" : "N") + "'";
            }
            return (Boolean)value != false ? "1" : "0";
        }
        if (valType.equals(COL_DATE)) {
            if (dialect.equals(DIALECT_ORACLE)) {
                return "TO_DATE(SUBSTR('" + value + "', 1, 10), 'YYYY-MM-DD')";
            }
            return "'" + value + "'";
        }
        if (valType.equals(COL_TIME)) {
            if (dialect.equals(DIALECT_ORACLE)) {
                return "TO_TIMESTAMP('" + value + "', 'YYYY-MM-DD HH24:MI:SS')";
            }
            return "'" + value + "'";
        }
        throw new WebException(504, "\u4f20\u9012\u6570\u636e\u7c7b\u578b\u51fa\u9519");
    }

    public void loadMetaData() {
        Map map = this.sessionFactory.getAllClassMetadata();
        for (String entityName : map.keySet()) {
            try {
                this.getMetaData(entityName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SAXReader reader = new SAXReader();
        InputStream input = SqlMapper.class.getClassLoader().getResourceAsStream("subclass.xml");
        try {
            Document document = reader.read(input);
            Element root = document.getRootElement();
            Iterator it = root.elementIterator("entity");
            while (it.hasNext()) {
                HashMap subclasses;
                Element elm = (Element)it.next();
                String entityName = elm.attribute("name").getValue();
                String parentEntity = elm.attribute("parentEntity").getValue();
                String discriminator = elm.attribute("discriminator").getValue();
                String discProperty = elm.attribute("discProperty").getValue();
                if (!metaMap.containsKey(parentEntity)) continue;
                HashMap<String, Object> em = metaMap.get(parentEntity);
                if (em.containsKey("subclasses")) {
                    subclasses = (HashMap)em.get("subclasses");
                } else {
                    subclasses = new HashMap();
                    em.put("subclasses", subclasses);
                }
                subclasses.put(entityName, new Pair(discProperty, discriminator));
                entityLiftMap.put(entityName, parentEntity);
            }
        }
        catch (DocumentException ex) {
            throw new RuntimeException(ex);
        }
        for (String entityName : map.keySet()) {
            try {
                HashMap<String, Object> hash = metaMap.get(entityName);
                ClassMetadata cmd = this.sessionFactory.getClassMetadata(entityName);
                HashMap<String, String> inverses = new HashMap<String, String>();
                hash.put("inverses", inverses);
                for (String property : cmd.getPropertyNames()) {
                    Type type = cmd.getPropertyType(property);
                    if (!(type instanceof ManyToOneType)) continue;
                    ManyToOneType mto = (ManyToOneType)type;
                    String linkedEntity = mto.getAssociatedEntityName();
                    String colName = mto.getAssociatedJoinable((SessionFactoryImplementor)this.sessionFactory).getKeyColumnNames()[0];
                    inverses.put(property, linkedEntity);
                    HashMap<String, Pair> inverseMap = new HashMap<String, Pair>();
                    hash.put("inverseid", inverseMap);
                    inverseMap.put(property, new Pair(colName, (String)metaMap.get(linkedEntity).get("idType")));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.debug((Object)"meta data all loaded.");
    }

    public JSONObject action(JSONObject params) {
        log.debug((Object)("action:" + params));
        String method = params.getString("method");
        if (method.equals("save")) {
            String entity = params.getString("entity");
            JSONObject json = params.getJSONObject("data");
            try {
                String result = this.partialSave(entity, json);
                return new JSONObject(result);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new JSONObject();
    }
}

