package com.aote.util;

import com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerException;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Types;

/**
 * 初始化数据工具类
 * 提供一些数据的初始化操作
 */
public class InitDataHelper {
    /**
     * 批量更新方法，使用 SQLServerBulkCSVFileRecord
     *
     * @param destinationConnectionUrl 目标地址
     * @param destinationTableName     目标表名
     * @param csvFilePath              源数据路径
     * @return true 表示成功
     * @description 注意：使用该类需要CSV格式首行为字段名称 且 导出csv文件的时候不要使用" '等特殊符号分隔
     */
    public static boolean bitchUpdateBySQLServerBulkCSVFileRecord(String destinationConnectionUrl, String destinationTableName, String csvFilePath) {
        Connection destinationConnection = null;//目标
        SQLServerBulkCSVFileRecord sourceData = null;//数据源
        try {
            //获取源数据
            sourceData = getCSVFileData(csvFilePath);
            //初始化写入配置
            destinationConnection = DriverManager.getConnection(destinationConnectionUrl);
            SQLServerBulkCopy bulkCopy = new SQLServerBulkCopy(destinationConnection);
            bulkCopy.setDestinationTableName(destinationTableName);
            for (int i = 0; i < sourceData.getRowData().length; i++) {
                bulkCopy.addColumnMapping(sourceData.getRowData()[i].toString(), sourceData.getRowData()[i].toString().toLowerCase());

            }
            //向目标地址写入数据
            bulkCopy.writeToServer(sourceData);
            //资源关闭
            bulkCopy.close();
            destinationConnection.close();
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     * 读取csv文件中的数据
     *
     * @param csvFilePath
     * @return
     * @throws SQLServerException
     */
    public static SQLServerBulkCSVFileRecord getCSVFileData(String csvFilePath) throws SQLServerException {
        SQLServerBulkCSVFileRecord fileRecord = new SQLServerBulkCSVFileRecord(csvFilePath, true);
        for (int i = 0; i < fileRecord.getRowData().length; i++) {
            fileRecord.addColumnMetadata(i + 1, null, Types.NVARCHAR, 0, 0);
        }
        return fileRecord;
    }
}
