package com.aote.path;

import com.af.path.Delegate;
import com.af.path.Program;
import org.hibernate.Session;
import org.json.JSONArray;

import java.util.HashMap;

public class PathHelper {
	@SuppressWarnings("unchecked")
	public static JSONArray query(Session session, String sql) {
		Program prog = new Program(sql);
		Delegate d = prog.parse();
		d.session = session;
		return (JSONArray) d.invoke(new HashMap<>(), session.getSessionFactory());
	}

	@SuppressWarnings("unchecked")
	public static JSONArray query(Session session, String sql, int pageNo,
			int pageSize) {
		Program prog = new Program(sql);
		Delegate d = prog.parse();
		d.session = session;
		// 设置sql执行器为分页执行器
		d.sqlRunner = new PagedSqlRunner(pageNo, pageSize);
		return (JSONArray) d.invoke(new HashMap<>(), session.getSessionFactory());
	}
}
