/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util;

import com.aote.v4.compatibility.core.utils.SpringUtils;
import com.aote.v4.compatibility.liuli.config.service.LiuLiConfigService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstitutionCipherUtil {
    private static final Logger log = LoggerFactory.getLogger(SubstitutionCipherUtil.class);
    private static final int CIPHER_LENGTH = 4;
    private static volatile String currentVersion;
    private static final Map<String, VersionCipherTable> versionTables;
    private static final ReentrantReadWriteLock lock;
    private static volatile boolean initialized;

    public static void init() {
        lock.writeLock().lock();
        try {
            log.info("\u5f00\u59cb\u521d\u59cb\u5316\u5bc6\u7801\u8868");
            LiuLiConfigService liuLi = (LiuLiConfigService)SpringUtils.getBean(LiuLiConfigService.class);
            JSONObject cfg = liuLi.get("cipherTableConfig");
            if (cfg == null) {
                throw new RuntimeException("LiuLi \u672a\u8fd4\u56de cipherTableConfig");
            }
            String enableVersion = cfg.optString("enableVersion", null);
            if (enableVersion == null) {
                throw new RuntimeException("cipherTableConfig \u7f3a\u5c11 enableVersion \u5b57\u6bb5");
            }
            versionTables.clear();
            for (String key : cfg.keySet()) {
                JSONObject versionObj;
                if ("enableVersion".equals(key) || key.startsWith("$") || (versionObj = cfg.optJSONObject(key)) == null || versionObj.isEmpty()) continue;
                VersionCipherTable table = SubstitutionCipherUtil.loadVersionTable(key, versionObj);
                versionTables.put(key, table);
                log.info("\u52a0\u8f7d\u5bc6\u7801\u8868\u7248\u672c {}\uff0c\u6620\u5c04\u6570\u91cf: {}", (Object)key, (Object)table.encryptMap().size());
            }
            if (!versionTables.containsKey(enableVersion)) {
                throw new RuntimeException("\u542f\u7528\u7248\u672c " + enableVersion + " \u5728\u914d\u7f6e\u4e2d\u4e0d\u5b58\u5728");
            }
            currentVersion = enableVersion;
            initialized = true;
            log.info("\u5bc6\u7801\u8868\u521d\u59cb\u5316\u6210\u529f\uff0c\u5f53\u524d\u542f\u7528\u7248\u672c: {}\uff0c\u603b\u7248\u672c\u6570: {}", (Object)currentVersion, (Object)versionTables.size());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bc6\u7801\u8868\u521d\u59cb\u5316\u5931\u8d25", e);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private static VersionCipherTable loadVersionTable(String version, JSONObject versionObj) {
        HashMap<String, String> encryptMap = new HashMap<String, String>();
        for (String key : versionObj.keySet()) {
            encryptMap.put(key, versionObj.getString(key));
        }
        if (encryptMap.isEmpty()) {
            throw new RuntimeException("\u5bc6\u7801\u8868\u7248\u672c " + version + " \u6620\u5c04\u4e3a\u7a7a");
        }
        SubstitutionCipherUtil.validateCipherTable(encryptMap);
        HashMap<String, String> decryptMap = new HashMap<String, String>(encryptMap.size());
        for (Map.Entry entry : encryptMap.entrySet()) {
            String plaintext = (String)entry.getKey();
            String ciphertext = (String)entry.getValue();
            if (decryptMap.containsKey(ciphertext)) {
                throw new RuntimeException(String.format("\u5bc6\u7801\u8868\u7248\u672c %s \u4e2d\u5b58\u5728\u91cd\u590d\u7684\u5bc6\u6587: %s \u5bf9\u5e94\u591a\u4e2a\u660e\u6587: %s \u548c %s", version, ciphertext, decryptMap.get(ciphertext), plaintext));
            }
            decryptMap.put(ciphertext, plaintext);
        }
        return new VersionCipherTable(Collections.unmodifiableMap(encryptMap), Collections.unmodifiableMap(decryptMap));
    }

    public static void refresh() {
        SubstitutionCipherUtil.init();
    }

    private static void validateCipherTable(Map<String, String> cipherTable) {
        for (Map.Entry<String, String> entry : cipherTable.entrySet()) {
            String plaintext = entry.getKey();
            String ciphertext = entry.getValue();
            if (plaintext == null || plaintext.isEmpty()) {
                throw new RuntimeException("\u5bc6\u7801\u8868\u4e2d\u5b58\u5728\u7a7a\u7684\u660e\u6587\u952e");
            }
            if (ciphertext == null || ciphertext.length() != 4) {
                throw new RuntimeException(String.format("\u5bc6\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u660e\u6587 '%s' \u7684\u5bc6\u6587 '%s' \u957f\u5ea6\u4e0d\u4e3a %d", plaintext, ciphertext, 4));
            }
            char firstChar = ciphertext.charAt(0);
            if (firstChar < 'a' || firstChar > 'z') {
                throw new RuntimeException(String.format("\u5bc6\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u660e\u6587 '%s' \u7684\u5bc6\u6587 '%s' \u7b2c\u4e00\u4f4d\u4e0d\u662f\u5c0f\u5199\u5b57\u6bcd", plaintext, ciphertext));
            }
            for (int i = 1; i < 4; ++i) {
                char c = ciphertext.charAt(i);
                if (Character.isLetterOrDigit(c)) continue;
                throw new RuntimeException(String.format("\u5bc6\u6587\u683c\u5f0f\u9519\u8bef\uff0c\u660e\u6587 '%s' \u7684\u5bc6\u6587 '%s' \u7b2c %d \u4f4d\u4e0d\u662f\u5b57\u6bcd\u6216\u6570\u5b57", plaintext, ciphertext, i + 1));
            }
        }
    }

    private static void checkInitialized() {
        if (!initialized) {
            throw new IllegalStateException("\u5bc6\u7801\u8868\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 init() \u65b9\u6cd5");
        }
    }

    public static String encrypt(String plaintext) {
        if (plaintext == null) {
            log.warn("\u660e\u6587\u4e0d\u80fd\u4e3a null");
            return null;
        }
        SubstitutionCipherUtil.checkInitialized();
        if (plaintext.isEmpty()) {
            return plaintext;
        }
        String cipherBody = SubstitutionCipherUtil.encryptWithoutVersion(plaintext);
        return currentVersion + ":" + cipherBody;
    }

    private static String encryptWithoutVersion(String plaintext) {
        VersionCipherTable table = versionTables.get(currentVersion);
        if (table == null) {
            throw new IllegalStateException("\u5f53\u524d\u7248\u672c " + currentVersion + " \u7684\u5bc6\u7801\u8868\u4e0d\u5b58\u5728");
        }
        StringBuilder result = new StringBuilder(plaintext.length() * 4);
        for (int i = 0; i < plaintext.length(); ++i) {
            String character = String.valueOf(plaintext.charAt(i));
            String cipher = table.encryptMap().get(character);
            result.append(cipher != null ? cipher : character);
        }
        return result.toString();
    }

    public static String decrypt(String ciphertext) {
        if (ciphertext == null) {
            throw new IllegalArgumentException("\u5bc6\u6587\u4e0d\u80fd\u4e3a null");
        }
        SubstitutionCipherUtil.checkInitialized();
        if (ciphertext.isEmpty()) {
            return ciphertext;
        }
        int colonIndex = ciphertext.indexOf(58);
        if (colonIndex <= 0 || colonIndex > 10) {
            throw new IllegalArgumentException("\u5bc6\u6587\u683c\u5f0f\u9519\u8bef\uff1a\u7f3a\u5c11\u7248\u672c\u524d\u7f00\uff0c\u6b63\u786e\u683c\u5f0f\u4e3a version:cipher");
        }
        String version = ciphertext.substring(0, colonIndex);
        String cipherBody = ciphertext.substring(colonIndex + 1);
        VersionCipherTable table = versionTables.get(version);
        if (table == null) {
            throw new IllegalStateException("\u4e0d\u652f\u6301\u7684\u5bc6\u6587\u7248\u672c: " + version + "\uff0c\u5f53\u524d\u652f\u6301\u7248\u672c: " + String.valueOf(versionTables.keySet()));
        }
        return SubstitutionCipherUtil.decryptWithTable(cipherBody, table.decryptMap());
    }

    private static String decryptWithTable(String ciphertext, Map<String, String> decryptMap) {
        StringBuilder result = new StringBuilder(ciphertext.length());
        int i = 0;
        while (i < ciphertext.length()) {
            String cipherUnit;
            String plainChar;
            if (i + 4 <= ciphertext.length() && (plainChar = decryptMap.get(cipherUnit = ciphertext.substring(i, i + 4))) != null) {
                result.append(plainChar);
                i += 4;
                continue;
            }
            result.append(ciphertext.charAt(i));
            ++i;
        }
        return result.toString();
    }

    public static boolean equalsCipher(String newPlain, String existingCipher) {
        if (newPlain == null && (existingCipher == null || existingCipher.isEmpty())) {
            return true;
        }
        if (newPlain == null) {
            return false;
        }
        String newCipher = SubstitutionCipherUtil.encrypt(newPlain);
        return Objects.equals(newCipher, existingCipher);
    }

    public static boolean hasCipherChanged(String newPlain, String existingCipher) {
        return !SubstitutionCipherUtil.equalsCipher(newPlain, existingCipher);
    }

    public static boolean isStrictCipher(String value) {
        try {
            if (value == null || value.length() <= 6) {
                return false;
            }
            SubstitutionCipherUtil.checkInitialized();
            int colonIndex = value.indexOf(58);
            if (colonIndex <= 0 || colonIndex > 10) {
                return false;
            }
            String version = value.substring(0, colonIndex);
            if (!versionTables.containsKey(version)) {
                return false;
            }
            String cipherBody = value.substring(colonIndex + 1);
            if (cipherBody.isEmpty() || cipherBody.length() % 4 != 0) {
                return false;
            }
            Map<String, String> decryptMap = versionTables.get(version).decryptMap();
            for (int i = 0; i < cipherBody.length(); i += 4) {
                String block = cipherBody.substring(i, i + 4);
                if (decryptMap.containsKey(block)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getCurrentVersion() {
        SubstitutionCipherUtil.checkInitialized();
        return currentVersion;
    }

    public static Set<String> getSupportedVersions() {
        SubstitutionCipherUtil.checkInitialized();
        return Collections.unmodifiableSet(versionTables.keySet());
    }

    public static String parseVersion(String ciphertext) {
        if (ciphertext == null || ciphertext.isEmpty()) {
            return null;
        }
        int colonIndex = ciphertext.indexOf(58);
        return colonIndex > 0 && colonIndex < 10 ? ciphertext.substring(0, colonIndex) : null;
    }

    public static Map<String, String> getEncryptMap(String version) {
        SubstitutionCipherUtil.checkInitialized();
        VersionCipherTable table = versionTables.get(version);
        if (table == null) {
            throw new IllegalStateException("\u7248\u672c " + version + " \u4e0d\u5b58\u5728");
        }
        return table.encryptMap();
    }

    public static Map<String, String> getDecryptMap(String version) {
        SubstitutionCipherUtil.checkInitialized();
        VersionCipherTable table = versionTables.get(version);
        if (table == null) {
            throw new IllegalStateException("\u7248\u672c " + version + " \u4e0d\u5b58\u5728");
        }
        return table.decryptMap();
    }

    public static Map<String, String> getEncryptMap() {
        return SubstitutionCipherUtil.getEncryptMap(currentVersion);
    }

    public static Map<String, String> getDecryptMap() {
        return SubstitutionCipherUtil.getDecryptMap(currentVersion);
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static int getCipherLength() {
        return 4;
    }

    static {
        versionTables = new ConcurrentHashMap<String, VersionCipherTable>();
        lock = new ReentrantReadWriteLock();
        initialized = false;
        try {
            SubstitutionCipherUtil.init();
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u5bc6\u7801\u8868\u5931\u8d25", (Throwable)e);
        }
    }

    private static class VersionCipherTable {
        private final Map<String, String> encryptMap;
        private final Map<String, String> decryptMap;

        private VersionCipherTable(Map<String, String> encryptMap, Map<String, String> decryptMap) {
            this.encryptMap = encryptMap;
            this.decryptMap = decryptMap;
        }

        public Map<String, String> encryptMap() {
            return this.encryptMap;
        }

        public Map<String, String> decryptMap() {
            return this.decryptMap;
        }
    }
}

