/*
 * Decompiled with CFR 0.152.
 */
package com.aote.path;

import com.aote.ThreadResource;
import com.aote.util.IOTools;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PathMapper {
    static final Logger log = Logger.getLogger(PathMapper.class);
    private static Map<String, Map<String, String>> map;

    public static synchronized String getPath(String alias) {
        if (map == null) {
            PathMapper.loadMap();
        }
        if (map.containsKey(alias)) {
            String result = PathMapper.getPathByUser(alias);
            if (result != null) {
                return result;
            }
            return map.get(alias).get("path");
        }
        return null;
    }

    public static synchronized Map<String, Map<String, String>> getMap() {
        if (map == null) {
            PathMapper.loadMap();
        }
        return map;
    }

    public static synchronized String getAttr(String alias, String name) {
        if (map == null) {
            PathMapper.loadMap();
        }
        if (map.containsKey(alias)) {
            return map.get(alias).get(name);
        }
        return null;
    }

    public static String getPathByUser(String alias) {
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null) {
            return null;
        }
        String path = dir + "/paths/" + alias + ".path";
        if (IOTools.hasResource(path)) {
            return path;
        }
        return null;
    }

    private static void loadMap() {
        map = new HashMap<String, Map<String, String>>();
        SAXReader reader = new SAXReader();
        InputStream module = PathMapper.class.getClassLoader().getResourceAsStream("module.xml");
        try {
            InputStream input;
            if (module != null) {
                PathMapper.parseModule(module);
            }
            if ((input = PathMapper.class.getClassLoader().getResourceAsStream("path.xml")) != null) {
                Document document = reader.read(input);
                Element root = document.getRootElement();
                Iterator it = root.elementIterator("path");
                while (it.hasNext()) {
                    Element elm = (Element)it.next();
                    HashMap<String, Object> logic = new HashMap<String, Object>();
                    String alias = elm.attribute("alias").getValue();
                    logic.put("alias", alias);
                    String path = elm.attribute("path").getValue();
                    logic.put("path", "paths/" + path);
                    String log = elm.attributeValue("log");
                    logic.put("log", log);
                    String mobile = elm.attributeValue("mobile");
                    logic.put("mobile", mobile);
                    map.put(alias, logic);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void parseModule(InputStream input) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(input);
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("module");
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String name = elm.attribute("name").getValue();
            PathMapper.putMap(name, reader, null);
            Iterator children = elm.elementIterator("module");
            while (children.hasNext()) {
                Element childElm = (Element)children.next();
                String childname = childElm.attribute("name").getValue();
                PathMapper.putMap(childname, reader, name);
            }
        }
    }

    private static void putMap(String name, SAXReader reader, String parent) throws Exception {
        InputStream modulePath = PathMapper.class.getClassLoader().getResourceAsStream(parent == null ? name + "/path.xml" : parent + "/" + name + "/path.xml");
        if (modulePath == null) {
            log.warn((Object)("\u6a21\u5757\u6ca1\u6709path.xml\u6587\u4ef6, module=" + name));
            return;
        }
        Document docPath = reader.read(modulePath);
        Element rootPath = docPath.getRootElement();
        Iterator item = rootPath.elementIterator("path");
        while (item.hasNext()) {
            Element elmment = (Element)item.next();
            String aliasPath = elmment.attribute("alias").getValue();
            String pathPath = elmment.attribute("path").getValue();
            String log = elmment.attributeValue("log");
            String mobile = elmment.attributeValue("mobile");
            if (map.containsKey(aliasPath)) {
                throw new Exception("\u522b\u540d" + aliasPath + "\u5df2\u5b58\u5728");
            }
            String path = (parent == null ? name + "/paths/" : parent + "/" + name + "/paths/") + pathPath;
            HashMap<String, Object> logic = new HashMap<String, Object>();
            logic.put("alias", aliasPath);
            logic.put("path", path);
            logic.put("log", log);
            logic.put("mobile", mobile);
            map.put(aliasPath, logic);
        }
    }

    public void main(String[] args) {
        PathMapper.loadMap();
        for (String key : map.keySet()) {
            System.out.println(key);
        }
    }
}

