/*
 * Decompiled with CFR 0.152.
 */
package com.aote.filter;

import com.aote.ThreadResource;
import com.aote.filter.LoginFilter;
import com.aote.rs.mapper.WebException;
import com.aote.util.GetUserIp;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class LdapFilter
implements Filter {
    static final Logger log = Logger.getLogger(LdapFilter.class);

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Long startTime = System.currentTimeMillis();
        try {
            ThreadResource.LoginUser.set(null);
            ThreadResource.ComponentDir.set(null);
            ThreadResource.Token.set(null);
            HttpServletRequest req = (HttpServletRequest)request;
            String ip = GetUserIp.getIpAdrress(req);
            String url = ip + req.getRequestURI();
            log.debug((Object)("\u4f20\u5165\u7684URL:" + url));
            boolean isOk = LoginFilter.isOk(req, url, log);
            if (!isOk) {
                log.debug((Object)("\u7528\u6237\u8ba4\u8bc1\u5931\u8d25URL:" + url));
                throw new WebException(401, "\u7528\u6237\u8ba4\u8bc1\u5931\u8d25\uff01");
            }
            String sessionId = req.getHeader("session");
            ThreadResource.SessionId.set(sessionId == null ? null : Integer.valueOf(sessionId));
            String componentDir = req.getHeader("componentDir");
            log.debug((Object)("\u83b7\u53d6\u7684componentDir" + componentDir));
            if (componentDir != null) {
                ThreadResource.ComponentDir.set(componentDir);
            } else {
                String loginId = req.getHeader("Token");
                if (loginId != null) {
                    ThreadResource.Token.set(loginId);
                    log.debug((Object)("loginId=" + loginId));
                }
            }
            log.debug((Object)("\u8fdb\u5165chain.doFilter:" + url));
            chain.doFilter(request, response);
            log.debug((Object)("\u7ed3\u675fchain.doFilter:" + url));
            Long endTime = System.currentTimeMillis();
            log.debug((Object)(url + ",\u62e6\u622a\u5668\u8017\u65f6:" + (endTime - startTime)));
        }
        catch (Exception e) {
            log.error((Object)"\u62e6\u622a\u5668\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
    }

    public void destroy() {
    }
}

