/*
 * Decompiled with CFR 0.152.
 */
package com.aote.filter;

import com.aote.config.Config;
import com.aote.filter.RSAUtil;
import com.aote.util.JsonTransfer;
import com.aote.v4.compatibility.liuli.config.service.LiuLiConfigService;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class DesensitizationTool {
    public static final String KEY = "7xjgtQc4M8FOXikU7JkwcUI0wKhYkREt";
    static Logger log = Logger.getLogger(DesensitizationTool.class);

    public static void main(String[] args) throws Exception {
        System.out.println(DesensitizationTool.maskUserName("\u6768\u4e1c\u751f"));
    }

    public static JSONArray processEncryption(String token, List<Map<String, Object>> list) {
        JSONArray array = new JSONArray();
        if (!Config.isDesensitization()) {
            for (Map<String, Object> map : list) {
                array.put((Object)JsonTransfer.MapToJson(map));
            }
            return array;
        }
        log.debug((Object)("\u6743\u9650\u5224\u65ad" + token));
        boolean isAuthorized = Config.isAuthorization(token);
        LiuLiConfigService liuLiConfigService = DesensitizationTool.getSpringBean();
        JSONObject desensitizationConfig = liuLiConfigService.get("desensitizationConfig");
        log.debug((Object)("\u83b7\u53d6\u5230\u7684\u914d\u7f6e" + String.valueOf(desensitizationConfig)));
        JSONArray field = desensitizationConfig.optJSONArray("field", new JSONArray());
        HashSet<String> fieldSet = new HashSet<String>();
        for (int i = 0; i < field.length(); ++i) {
            fieldSet.add(field.getString(i));
        }
        log.debug((Object)("\u6743\u9650\u5224\u65ad" + isAuthorized));
        for (Map<String, Object> map : list) {
            JSONObject json = JsonTransfer.MapToJson(map);
            for (String key : json.keySet()) {
                Object value = json.get(key);
                if (!(value instanceof String)) continue;
                String strValue = (String)value;
                if (strValue.contains("|-") && strValue.contains("-|")) {
                    String processedValue = DesensitizationTool.processEncryptedField(strValue, isAuthorized);
                    if (!isAuthorized) {
                        if (fieldSet.contains(key)) {
                            json.put(key, (Object)("f_user_phone".equals(key) ? DesensitizationTool.maskPhoneNumber(processedValue) : DesensitizationTool.maskUserName(processedValue)));
                            continue;
                        }
                        json.put(key, (Object)("f_user_name".equals(key) ? DesensitizationTool.maskUserName(processedValue) : processedValue));
                        continue;
                    }
                    json.put(key, (Object)processedValue);
                    continue;
                }
                if (!isAuthorized) {
                    if (fieldSet.contains(key)) {
                        json.put(key, (Object)("f_user_phone".equals(key) ? DesensitizationTool.maskPhoneNumber(strValue) : DesensitizationTool.maskUserName(strValue)));
                        continue;
                    }
                    json.put(key, (Object)("f_user_name".equals(key) ? DesensitizationTool.maskUserName(strValue) : strValue));
                    continue;
                }
                json.put(key, (Object)strValue);
            }
            array.put((Object)json);
        }
        return array;
    }

    private static String processEncryptedField(String value, boolean isAuthorized) {
        Pattern pattern = Pattern.compile("\\|-.*?-\\|");
        Matcher matcher = pattern.matcher(value);
        StringBuffer sb = new StringBuffer(value.length());
        while (matcher.find()) {
            String match = matcher.group(0);
            Object replacement = match;
            if (isAuthorized) {
                try {
                    replacement = RSAUtil.aesDecrypt(match.replace("|-", "").replace("-|", ""), KEY);
                }
                catch (Exception e) {
                    log.debug((Object)"\u89e3\u5bc6\u5f02\u5e38", (Throwable)e);
                    replacement = match;
                }
            } else {
                String beforeEncrypt = match.substring(0, match.indexOf("|-"));
                String afterEncrypt = match.substring(match.indexOf("-|") + 2);
                replacement = beforeEncrypt + "****" + afterEncrypt;
            }
            matcher.appendReplacement(sb, (String)replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String maskUserName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        int length = name.length();
        StringBuilder masked = new StringBuilder();
        switch (length) {
            case 1: {
                return name;
            }
            case 2: {
                masked.append("*").append(name.charAt(1));
                break;
            }
            case 3: {
                masked.append(name.charAt(0)).append("*").append(name.charAt(2));
                break;
            }
            case 4: {
                masked.append(name.charAt(0)).append("**").append(name.charAt(3));
                break;
            }
            case 5: {
                masked.append(name.charAt(0)).append("***").append(name.charAt(4));
                break;
            }
            case 6: {
                masked.append(name.charAt(0)).append("****").append(name.charAt(5));
                break;
            }
            case 7: {
                masked.append(name.charAt(0)).append("*****").append(name.charAt(6));
                break;
            }
            case 8: {
                masked.append(name.charAt(0)).append("******").append(name.charAt(7));
                break;
            }
            default: {
                masked.append(name.charAt(0));
                for (int i = 1; i < length - 1; ++i) {
                    masked.append("*");
                }
                masked.append(name.charAt(length - 1));
            }
        }
        return masked.toString();
    }

    private static String maskPhoneNumber(String phone) {
        if (phone == null || phone.trim().isEmpty() || !DesensitizationTool.validatePhoneNumber(phone)) {
            return phone;
        }
        String pureNum = phone.replaceAll("[^0-9]", "");
        if (pureNum.matches("^1[3-9]\\d{9}$")) {
            return pureNum.substring(0, 3) + "****" + pureNum.substring(7);
        }
        Pattern landlinePattern = Pattern.compile("(0\\d{2,3})([\\-\\s]?)(\\d{7,8})");
        Matcher matcher = landlinePattern.matcher(phone);
        if (matcher.matches()) {
            String areaCode = matcher.group(1);
            String separator = matcher.group(2);
            String localNum = matcher.group(3);
            int hideLength = Math.max(localNum.length() - 4, 0);
            StringBuilder hideStrBuilder = new StringBuilder();
            for (int i = 0; i < hideLength; ++i) {
                hideStrBuilder.append("*");
            }
            String hideStr = hideStrBuilder.toString();
            String maskedLocal = hideStr + localNum.substring(Math.max(localNum.length() - 4, 0));
            return areaCode + separator + maskedLocal;
        }
        if (pureNum.startsWith("0")) {
            int areaCodeLen = pureNum.length() == 10 ? 3 : 4;
            String areaCode = pureNum.substring(0, areaCodeLen);
            String localNum = pureNum.substring(areaCodeLen);
            int hideLength = Math.max(localNum.length() - 4, 0);
            StringBuilder hideStrBuilder = new StringBuilder();
            for (int i = 0; i < hideLength; ++i) {
                hideStrBuilder.append("*");
            }
            String hideStr = hideStrBuilder.toString();
            String maskedLocal = hideStr + localNum.substring(Math.max(localNum.length() - 4, 0));
            return areaCode + maskedLocal;
        }
        return phone;
    }

    private static LiuLiConfigService getSpringBean() {
        WebApplicationContext wac = ContextLoader.getCurrentWebApplicationContext();
        return (LiuLiConfigService)wac.getBean("liuLiConfigService");
    }

    private static boolean validatePhoneNumber(String phone) {
        if (phone == null || phone.trim().isEmpty()) {
            return false;
        }
        String pureNum = phone.replaceAll("[^0-9]", "");
        if (pureNum.matches("^1[3-9]\\d{9}$")) {
            return true;
        }
        Pattern landlinePattern = Pattern.compile("^0\\d{2,3}([\\-\\s]?)\\d{7,8}$");
        Matcher landlineMatcher = landlinePattern.matcher(phone);
        if (landlineMatcher.matches()) {
            return true;
        }
        return pureNum.length() >= 10 && pureNum.length() <= 11 && pureNum.startsWith("0") && pureNum.substring(1).matches("\\d{9,10}");
    }
}

