/*
 * Decompiled with CFR 0.152.
 */
package com.aote.file;

import com.aote.file.FileCheck;
import com.aote.file.IFile;
import com.aote.util.ExceptionHelper;
import com.aote.util.JsonTransfer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class FileServer {
    static final Logger log = Logger.getLogger(FileServer.class);
    private IFile fileCheck = null;

    public void setChecker(IFile check) {
        this.fileCheck = check;
    }

    public void setChecker(String checkName) throws Exception {
        try {
            Class<?> c = Class.forName(checkName);
            this.fileCheck = (IFile)c.newInstance();
        }
        catch (Exception e) {
            log.error((Object)ExceptionHelper.stackToString(e));
            throw e;
        }
    }

    public byte[] read(String filePath) throws Exception {
        if (filePath == null || filePath.length() <= 0) {
            return null;
        }
        filePath = this.formatPath(filePath);
        byte[] buffer = null;
        File file = new File(filePath);
        BasicFileAttributes basicFileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        if (file.exists() && basicFileAttributes.isRegularFile()) {
            FileInputStream fis = new FileInputStream(file);
            buffer = new byte[(int)basicFileAttributes.size()];
            fis.read(buffer);
            fis.close();
            log.debug((Object)("\u8bfb\u53d6\u6587\u4ef6\uff08" + filePath + "\uff09\u5185\u5bb9\uff1a" + new String(buffer)));
        }
        return buffer;
    }

    public JSONObject read(String filePath, boolean readChild) {
        if (filePath == null || filePath.length() <= 0) {
            return null;
        }
        filePath = this.formatPath(filePath);
        JSONObject obj = null;
        File file = new File(filePath);
        if (file.exists() && file.isDirectory()) {
            obj = JsonTransfer.MapToJson(this.readFolder(file, readChild));
            log.debug((Object)("\u8bfb\u53d6\u6587\u4ef6\u5939\uff08" + filePath + "\uff09\u76ee\u5f55\uff1a" + String.valueOf(obj)));
        }
        return obj;
    }

    public String write(byte[] buffer, int length, String filePath, boolean append) throws Exception {
        if (buffer == null || filePath == null || filePath.length() <= 0) {
            return null;
        }
        String folderPath = (filePath = this.formatPath(filePath)).substring(0, filePath.lastIndexOf(File.separatorChar));
        File file = new File(folderPath);
        if (!file.exists()) {
            log.debug((Object)("\u521b\u5efa\u76ee\u5f55" + (file.mkdirs() ? "\u6210\u529f\uff08" : "\u5931\u8d25\uff08") + folderPath + "\uff09"));
        }
        FileOutputStream fos = new FileOutputStream(filePath, append);
        fos.write(buffer, 0, length);
        fos.close();
        log.debug((Object)("\u5199\u5165\u6587\u4ef6\u5185\u5bb9\u6210\u529f\uff08" + filePath + "\uff09:" + new String(buffer)));
        return "ok";
    }

    public String delete(String filePath) {
        if (filePath == null || filePath.length() <= 0) {
            return null;
        }
        File file = new File(filePath = this.formatPath(filePath));
        if (file.exists()) {
            if (file.isDirectory()) {
                log.debug((Object)("\u5220\u9664\u76ee\u5f55" + (this.deleteFolder(file) ? "\u6210\u529f\uff08" : "\u5931\u8d25\uff08") + filePath + "\uff09"));
            } else {
                log.debug((Object)("\u5220\u9664\u6587\u4ef6" + (file.delete() ? "\u6210\u529f\uff08" : "\u5931\u8d25\uff08") + filePath + "\uff09"));
            }
        }
        return "ok";
    }

    public JSONObject find(String filePath, boolean findChild, IFile check) {
        if (filePath == null || filePath.length() <= 0) {
            return null;
        }
        filePath = this.formatPath(filePath);
        JSONObject obj = null;
        File file = new File(filePath);
        if (file.exists() && file.isDirectory()) {
            if (check != null) {
                this.fileCheck = check;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            obj = JsonTransfer.MapToJson(this.findFile(file, findChild, map));
            log.debug((Object)("\u67e5\u627e\u6587\u4ef6\u5939\uff08" + filePath + "|" + String.valueOf(this.fileCheck.getClass()) + "\uff09\u7ed3\u679c\uff1a" + String.valueOf(obj)));
        }
        return obj;
    }

    private String formatPath(String path) {
        path = File.separatorChar == '\\' ? path.replaceAll("/", "" + File.separatorChar) : path.replaceAll("\\", "" + File.separatorChar);
        return path;
    }

    private boolean deleteFolder(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            for (String child : children = dir.list()) {
                boolean success = this.deleteFolder(new File(dir, child));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private Map<String, Object> readFolder(File dir, boolean readChild) {
        String[] children;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(".", this.readFileParam(dir));
        for (String child : children = dir.list()) {
            File f = new File(dir, child);
            if (f.isDirectory()) {
                if (readChild) {
                    map.put(child, this.readFolder(f, readChild));
                    continue;
                }
                map.put(child, this.readFileParam(f));
                continue;
            }
            map.put(child, this.readFileParam(f));
        }
        return map;
    }

    private Map<String, Object> findFile(File dir, boolean readChild, Map<String, Object> map) {
        String[] children;
        for (String child : children = dir.list()) {
            File f = new File(dir, child);
            if (f.isDirectory()) {
                if (!readChild) continue;
                this.findFile(f, readChild, map);
                continue;
            }
            if (!this.fileCheck.isFile(f)) continue;
            map.put(child, this.readFileParam(f));
        }
        return map;
    }

    private Map<String, Object> readFileParam(File file) {
        if (this.fileCheck == null) {
            this.fileCheck = new FileCheck(null);
        }
        return this.fileCheck.readParam(file);
    }

    public static void main(String[] args) throws Exception {
        FileServer s = new FileServer();
        s.write("1".getBytes(), 1, "D:\\1\\3\\2.txt", true);
        s.write("1".getBytes(), 1, "D:\\1\\2\\2.txt", true);
        s.write("2".getBytes(), 1, "D:\\1\\2\\2.txt", true);
        System.out.println(s.read("D:\\1", true).toString());
        System.out.println(new String(s.read("D:\\1\\2\\2.txt")));
        System.out.println(s.find("E:\\workarea\\workspace\\htapps\\java\\htapps", true, new FileCheck(".xml")).toString());
    }
}

