package com.aote.util.other;

import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.json.JSONObject;

import java.io.IOException;


/**
 * REST风格请求插件
 */
public class RestTools {

	/**
	 * 发送通用Http请求
	 * @param path  请求路径
	 * @param value 请求参数
	 * @param headers 请求头
	 * @param base  请求类型
	 * @return  请求结果
	 */
	public static String request(String path, String value, String headers, HttpRequestBase base){
		try {
			JSONObject headerJson;
			if(headers == null || headers.equals("")){
				headerJson = new JSONObject();
			} else {
				headerJson = new JSONObject(headers);
			}
			if(!headerJson.has("Content-Type")){
				//指定请求参数的数据格式是JSON。
				headerJson.put("Content-Type", "application/json");
			}
			headerJson.put("appToken", "db4afb0c04ab4af0b5626998fe7c9b21");
			return HttpConnectionPoolUtil.request(path, value, headerJson.toString(), base);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 发送post请求
	 *
	 * @param path    请求路径
	 * @param value   请求体
	 * @param headers  请求头
	 * @return String结果
	 */
	public static String post(String path, String value, String headers) {
		return request(path, value, headers, new HttpPost());
	}
	public static String post(String path, JSONObject value, JSONObject headers) {
		if(value == null){
			return post(path, null, headers.toString());
		} else {
			return post(path, value.toString(), headers.toString());
		}
	}
	public static String post(String path, JSONObject value) {
		return post(path, value.toString(), null);
	}
	public static String post(String path, String value) {
		return post(path, value, null);
	}
	public static String post(String path){
		return post(path, "",null);
	}

	/**
	 * 发送get请求
	 * @param path	请求路径
	 * @param headers 请求头
	 * @return String结果
	 */
	public static String get(String path, String headers) {
		return request(path, null, headers, new HttpGet());
	}
	public static String get(String path, JSONObject headers){
		return get(path, headers.toString());
	}
	public static String get(String path) {
		return get(path, "");
	}
}
