package com.aote.util;

import com.aote.config.Config;
import com.aote.config.SystemConfig;
import com.aote.rs.mapper.WebException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import javax.servlet.http.HttpServletRequest;

/**
 * 为业务逻辑提供各种辅助功能
 *
 * @author he
 */
public class Util {

    static final Logger log = Logger.getLogger(Util.class);

    /**
     * 抛异常
     */
    public void error(JSONObject param) {
        int status = Integer.parseInt(param.get("status").toString());
        String msg = (String) param.get("msg");
        throw new WebException(status, msg);
    }

    /**
     * 加密验证
     *
     * @param params 请求数据
     * @param url    请求url
     */
    public static void checkEncry(JSONObject params, String url) {
        // 强制加密, 但是参数是明文
        if (!params.has("aoteEncrypt") && SystemConfig.DataSecurity.getEnableDataEncryption()) {
            // 判断是否是放行url
            String passUrl = SystemConfig.DataSecurity.getPassUrl();
            String[] split = passUrl.split("-");
            for (int i = 0; i < split.length; i++) {
                if (url.equals(split[i])) {
                    return;
                }
            }
            // 判断参数是否携带密匙
            if (params.toString().contains(SystemConfig.DataSecurity.getAesKey())) {
                return;
            }
            throw new RuntimeException("数据要求强制加密！");
        }
    }

    /**
     * 加密白名单验证, 如果是白名单加入通过key
     *
     * @param req    request对象
     * @param params 请求参数
     * @return 返回请求参数
     */
    public static String aesWhiteList(HttpServletRequest req, String params) {
        String aesKey = SystemConfig.DataSecurity.getAesKey();
        // 如果后台是强制加密, 密匙有值
        if (req != null && SystemConfig.DataSecurity.getEnableDataEncryption() && StringUtils.isNotBlank(aesKey)) {
            String aesPass = Config.config.getString("aesPass");
            // 有白名单
            if (StringUtils.isNotBlank(aesPass)) {
                String ip = GetUserIp.getIpAdrress(req);
                String url = ip + req.getRequestURI();
                log.debug("加密白名单验证URL:" + url);
                // 是否是白名单请求
                boolean isWhite = false;
                for (String item : aesPass.split("-")) {
                    if (url.contains(item)) {
                        isWhite = true;
                        break;
                    }
                }
                if (isWhite) {
                    JSONObject paramJson = new JSONObject(params);
                    params = paramJson.put("key", aesKey).toString();
                }
            }
        }
        return params;
    }

}
