package com.aote.timer;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

import org.json.JSONArray;
import org.json.JSONObject;

import com.aote.util.FileReaderUtil;

/**
 * 银行对账源
 *
 * @author 111
 *
 */
public class BankBalanceAccountSource implements ISource {

	private String jsonFileName;

	private List<String> bankCodes;

	private List<String> filePaths;

	@Override
	public Object getSource() {
		List<JSONArray> listArr = new ArrayList<JSONArray>();
		for (int i = 0; i < filePaths.size(); i++) {
			JSONArray arr = new JSONArray();
			JSONObject jo = new JSONObject();
			String filePath = filePaths.get(i);
			String bankCode = bankCodes.get(i);
			String fileName = filePath + bankCode + getDate() + ".txt";
			String bankDate = getBankDate(fileName);
			JSONArray records = getRecords(fileName);
			jo.put("bankDate", bankDate);
			jo.put("records", records);
			arr.put(jo);
			listArr.add(arr);
		}
		return listArr;
	}

	private String getDate() {
		SimpleDateFormat formater = new SimpleDateFormat("yyyyMMdd");
		return formater.format(new Date());
	}

	/**
	 * 获取文件中的汇总时间
	 *
	 * @return JSONObject
	 */
	private String getBankDate(String fileName) {
		Scanner in = null;
		String date = null;
		try {
			in = new Scanner(new File(fileName));
			while (in.hasNextLine()) {
				String str = in.nextLine().trim();
				String[] huiZong = str.split("\\|");
				String s = huiZong[0];
				date = s.substring(0, 4) + "-" + s.substring(4, 6) + "-" + s.substring(6, 8);
				break;
			}
			in.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} finally {
			if (in != null) {
				in.close();
			}
		}
		return date;
	}

	/**
	 * 获取文件中的交易记录
	 *
	 * @return JSONArray
	 */
	private JSONArray getRecords(String fileName) {
		JSONArray records = new JSONArray();
		int count = 0;
		try (Scanner in = new Scanner(new File(fileName))) {
			while (in.hasNextLine()) {
				if (count == 0) {
					// 第一行的内容不需要读取
					in.nextLine();
					count++;
					continue;
				}
				String str = in.nextLine().trim();
				String[] arr = str.split("\\|");
				Map<String, Object> record = new HashMap<String, Object>();
				JSONObject jo = FileReaderUtil.readJSONFile(jsonFileName);
				JSONArray ja = jo.getJSONArray("field");
				for (int i = 0; i < ja.length(); i++) {
					if (ja.getString(i).toLowerCase().endsWith("num") || ja.getString(i).toLowerCase().endsWith("fee")) {
						// 把数值中补位用的0去掉
						record.put(ja.getString(i), Integer.parseInt(arr[3].replaceFirst("^0*", "")));
					} else {
						record.put(ja.getString(i), arr[i]);
					}
				}
				records.put(record);
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return records;
	}

	public List<String> getBankCodes() {
		return bankCodes;
	}

	public void setBankCodes(List<String> bankCodes) {
		this.bankCodes = bankCodes;
	}

	public List<String> getFilePaths() {
		return filePaths;
	}

	public void setFilePaths(List<String> filePaths) {
		this.filePaths = filePaths;
	}

	public String getJsonFileName() {
		return jsonFileName;
	}

	public void setJsonFileName(String jsonFileName) {
		this.jsonFileName = jsonFileName;
	}

}
