/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util.other;

import com.aote.config.SystemConfig;
import com.aote.util.ParamFilter;
import com.aote.util.Util;
import com.aote.util.other.Base64Utils;
import com.aote.util.other.RSAUtil;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;
import org.springframework.util.StringUtils;

public class AESUtil {
    private static final String ALGORITHMSTR = "AES/ECB/PKCS5Padding";
    private static final String[] SPECIAL_CHAR = new String[]{"vpn"};

    public static String encrypt(String content, String encryptKey) {
        try {
            return AESUtil.aesEncrypt(content, encryptKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String decrypt(String content, String encryptKey) {
        try {
            return AESUtil.aesDecrypt(content, encryptKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String binary(byte[] bytes, int radix) {
        return new BigInteger(1, bytes).toString(radix);
    }

    public static byte[] aesEncryptToBytes(String content, String encryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(1, new SecretKeySpec(encryptKey.getBytes(), "AES"));
        return cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
    }

    public static String aesEncrypt(String content, String encryptKey) throws Exception {
        return Base64Utils.encode(AESUtil.aesEncryptToBytes(content, encryptKey));
    }

    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128);
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(2, new SecretKeySpec(decryptKey.getBytes(), "AES"));
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes, StandardCharsets.UTF_8);
    }

    public static String aesDecrypt(String encryptStr, String decryptKey) throws Exception {
        return StringUtils.isEmpty((Object)encryptStr) ? null : AESUtil.aesDecryptByBytes(Base64Utils.decodeBuffer(encryptStr), decryptKey);
    }

    public static String addDecrypt(String paramStr) {
        if (SystemConfig.DataSecurity.getEnableDataEncryption() && SystemConfig.DataSecurity.hasAesKey()) {
            String encryKey = SystemConfig.DataSecurity.getAesKey();
            return AESUtil.encrypt(paramStr, encryKey);
        }
        return paramStr;
    }

    public static String getEncrypt(String str) {
        if (SystemConfig.DataSecurity.getEnableDataEncryption() && SystemConfig.DataSecurity.hasAesKey()) {
            String encryKey = SystemConfig.DataSecurity.getAesKey();
            return AESUtil.decrypt(str, encryKey);
        }
        return str;
    }

    public static String encryptData(JSONObject paramJson, String url, AfterFunction defaultFunction) throws Exception {
        Util.checkEncry(paramJson, url);
        if (!paramJson.has("aoteEncrypt")) {
            paramJson.put("aoteEncrypt", (Object)"default");
        }
        boolean sqlInject = SystemConfig.DataSecurity.getInjectionCheck();
        if ("AES".equals(paramJson.getString("aoteEncrypt"))) {
            if (!SystemConfig.DataSecurity.hasAesKey()) {
                throw new RuntimeException("\u672a\u5728systemConfig.json\u4e2d\u914d\u7f6eAES\u5bc6\u94a5\u4fe1\u606f\uff01");
            }
            String encryKey = SystemConfig.DataSecurity.getAesKey();
            String data = paramJson.getString("data");
            String decryData = AESUtil.decrypt(data, encryKey);
            if (decryData.startsWith("\"$")) {
                decryData = RSAUtil.descrypt(decryData.replaceAll("\"", "").substring(1));
            }
            if (sqlInject) {
                ParamFilter.checkSqlJsonStr(decryData);
            }
            String result = defaultFunction.run(decryData);
            String encryptData = AESUtil.encrypt(result, encryKey);
            for (String specialChar : SPECIAL_CHAR) {
                if (!result.toLowerCase().contains(specialChar)) continue;
                return result;
            }
            return encryptData;
        }
        paramJson.remove("aoteEncrypt");
        String paramData = paramJson.toString();
        if (sqlInject) {
            ParamFilter.checkSqlJsonStr(paramData);
        }
        return defaultFunction.run(paramData);
    }

    @FunctionalInterface
    public static interface AfterFunction {
        public String run(String var1) throws Exception;
    }
}

