/*
 * Decompiled with CFR 0.152.
 */
package com.aote.util.other;

import com.aote.util.other.Config;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class HttpConnectionPoolUtil {
    private static final Logger logger = Logger.getLogger(HttpConnectionPoolUtil.class);
    private static final int CONNECT_TIMEOUT = Config.getConnectTimeout();
    private static final int SOCKET_TIMEOUT = Config.getSocketTimeout();
    private static final int MAX_CONN = Config.getHttpMaxPoolSize();
    private static volatile CloseableHttpClient httpClient;
    private static final Object syncLock;

    private static void setRequestConfig(HttpRequestBase httpRequestBase) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(CONNECT_TIMEOUT).setConnectTimeout(CONNECT_TIMEOUT).setSocketTimeout(SOCKET_TIMEOUT).build();
        httpRequestBase.setConfig(requestConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient getHttpClient() {
        if (httpClient == null) {
            Object object = syncLock;
            synchronized (object) {
                if (httpClient == null) {
                    httpClient = HttpConnectionPoolUtil.createHttpClient();
                }
            }
        }
        return httpClient;
    }

    public static CloseableHttpClient getHttpClient(LayeredConnectionSocketFactory sslSocketFactory) {
        return HttpConnectionPoolUtil.createHttpClient(sslSocketFactory);
    }

    private static CloseableHttpClient createHttpClient() {
        return HttpConnectionPoolUtil.createHttpClient(null);
    }

    private static CloseableHttpClient createHttpClient(LayeredConnectionSocketFactory sslSocketFactory) {
        if (sslSocketFactory == null) {
            logger.debug((Object)"\u521b\u5efahttp\u5ba2\u6237\u7aef\u4f1a\u8bdd");
            sslSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
        } else {
            logger.debug((Object)"\u521b\u5efahttps\u5ba2\u6237\u7aef\u4f1a\u8bdd");
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(registry);
        manager.setMaxTotal(MAX_CONN);
        manager.setDefaultMaxPerRoute(MAX_CONN);
        ConnectionKeepAliveStrategy myStrategy = (response, context) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !"timeout".equalsIgnoreCase(param)) continue;
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            HttpHost target = (HttpHost)context.getAttribute("http.target_host");
            if ("www.naughty-server.com".equalsIgnoreCase(target.getHostName())) {
                return 5000L;
            }
            return 30000L;
        };
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false)).setKeepAliveStrategy(myStrategy).evictExpiredConnections().evictIdleConnections((long)Config.getHttpIdelTimeout(), TimeUnit.MILLISECONDS).build();
    }

    private static void setPostParams(HttpEntityEnclosingRequestBase base, String params) {
        if (params != null && !"".equals(params)) {
            StringEntity se = new StringEntity(params, StandardCharsets.UTF_8);
            base.setEntity((HttpEntity)se);
        }
    }

    private static void setHeaders(HttpRequestBase base, String headersStr) {
        if (headersStr != null && !"".equals(headersStr)) {
            JSONObject headers = new JSONObject(headersStr);
            Iterator keys = headers.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String val = String.valueOf(headers.get(key));
                base.setHeader(key, val);
            }
        }
    }

    public static String request(String path, String value, String headersStr, HttpRequestBase base) throws IOException {
        return HttpConnectionPoolUtil.request(path, value, headersStr, base, HttpConnectionPoolUtil.getHttpClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(String path, String value, String headersStr, HttpRequestBase base, CloseableHttpClient httpClient) throws IOException {
        String result;
        HttpConnectionPoolUtil.setRequestConfig(base);
        if (base instanceof HttpEntityEnclosingRequestBase) {
            HttpConnectionPoolUtil.setPostParams((HttpEntityEnclosingRequestBase)base, value);
        }
        HttpConnectionPoolUtil.setHeaders(base, headersStr);
        base.setURI(URI.create(path));
        try (CloseableHttpResponse response = null;){
            long begin = System.currentTimeMillis();
            response = httpClient.execute((HttpUriRequest)base, (HttpContext)HttpClientContext.create());
            long end = System.currentTimeMillis();
            long time = end - begin;
            String text = "\u8bf7\u6c42\u63a5\u53e3\u8017\u65f6\uff1a" + time + "ms";
            if (time >= 500L) {
                logger.warn((Object)text);
            } else {
                logger.info((Object)text);
            }
            String code = String.valueOf(response.getStatusLine().getStatusCode());
            if (code.startsWith("2")) {
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    String string = null;
                    return string;
                }
                result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            } else {
                String data = response.getStatusLine().getReasonPhrase();
                HttpEntity entity = response.getEntity();
                String errorEntity = entity != null ? EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8) : "";
                result = "{status: " + code + ", data: '" + data + "', errorEntity: '" + errorEntity + "'}";
            }
        }
        return result;
    }

    public static void closeConnectionPool(CloseableHttpClient httpClient, PoolingHttpClientConnectionManager manager) {
        try {
            httpClient.close();
            manager.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String requestFormUrlEncoded(String path, JSONObject params, HttpEntityEnclosingRequestBase base, CloseableHttpClient client) throws IOException {
        HttpConnectionPoolUtil.setRequestConfig((HttpRequestBase)base);
        base.setURI(URI.create(path));
        base.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpConnectionPoolUtil.paramsConverter(params)));
        String result = null;
        try (CloseableHttpResponse response = null;){
            long begin = System.currentTimeMillis();
            response = client.execute((HttpUriRequest)base, (HttpContext)HttpClientContext.create());
            long end = System.currentTimeMillis();
            long time = end - begin;
            String text = "\u8bf7\u6c42\u63a5\u53e3\u8017\u65f6\uff1a" + time + "ms";
            if (time >= 500L) {
                logger.warn((Object)text);
            } else {
                logger.info((Object)text);
            }
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        return result;
    }

    public static String requestFormUrlEncoded(String path, Map<String, String> params, HttpEntityEnclosingRequestBase base, CloseableHttpClient client) throws IOException {
        return HttpConnectionPoolUtil.requestFormUrlEncoded(path, new JSONObject(params), base, client);
    }

    private static List<NameValuePair> paramsConverter(JSONObject params) {
        LinkedList<NameValuePair> nvps = new LinkedList<NameValuePair>();
        Set paramsSet = params.keySet();
        for (String key : paramsSet) {
            nvps.add((NameValuePair)new BasicNameValuePair(key, String.valueOf(params.get(key))));
        }
        return nvps;
    }

    static {
        syncLock = new Object();
    }
}

