/*
 * Decompiled with CFR 0.152.
 */
package com.aote.timer;

import com.aote.timer.ISource;
import com.aote.util.FileReaderUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONObject;

public class BankBalanceAccountSource
implements ISource {
    private String jsonFileName;
    private List<String> bankCodes;
    private List<String> filePaths;

    @Override
    public Object getSource() {
        ArrayList<JSONArray> listArr = new ArrayList<JSONArray>();
        for (int i = 0; i < this.filePaths.size(); ++i) {
            JSONArray arr = new JSONArray();
            JSONObject jo = new JSONObject();
            String filePath = this.filePaths.get(i);
            String bankCode = this.bankCodes.get(i);
            String fileName = filePath + bankCode + this.getDate() + ".txt";
            String bankDate = this.getBankDate(fileName);
            JSONArray records = this.getRecords(fileName);
            jo.put("bankDate", (Object)bankDate);
            jo.put("records", (Object)records);
            arr.put((Object)jo);
            listArr.add(arr);
        }
        return listArr;
    }

    private String getDate() {
        SimpleDateFormat formater = new SimpleDateFormat("yyyyMMdd");
        return formater.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBankDate(String fileName) {
        String date = null;
        try (Scanner in = null;){
            in = new Scanner(new File(fileName));
            if (in.hasNextLine()) {
                String str = in.nextLine().trim();
                String[] huiZong = str.split("\\|");
                String s = huiZong[0];
                date = s.substring(0, 4) + "-" + s.substring(4, 6) + "-" + s.substring(6, 8);
            }
            in.close();
        }
        return date;
    }

    private JSONArray getRecords(String fileName) {
        JSONArray records = new JSONArray();
        int count = 0;
        try (Scanner in = new Scanner(new File(fileName));){
            while (in.hasNextLine()) {
                if (count == 0) {
                    in.nextLine();
                    ++count;
                    continue;
                }
                String str = in.nextLine().trim();
                String[] arr = str.split("\\|");
                HashMap<String, Object> record = new HashMap<String, Object>();
                JSONObject jo = FileReaderUtil.readJSONFile(this.jsonFileName);
                JSONArray ja = jo.getJSONArray("field");
                for (int i = 0; i < ja.length(); ++i) {
                    if (ja.getString(i).toLowerCase().endsWith("num") || ja.getString(i).toLowerCase().endsWith("fee")) {
                        record.put(ja.getString(i), Integer.parseInt(arr[3].replaceFirst("^0*", "")));
                        continue;
                    }
                    record.put(ja.getString(i), arr[i]);
                }
                records.put(record);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return records;
    }

    public List<String> getBankCodes() {
        return this.bankCodes;
    }

    public void setBankCodes(List<String> bankCodes) {
        this.bankCodes = bankCodes;
    }

    public List<String> getFilePaths() {
        return this.filePaths;
    }

    public void setFilePaths(List<String> filePaths) {
        this.filePaths = filePaths;
    }

    public String getJsonFileName() {
        return this.jsonFileName;
    }

    public void setJsonFileName(String jsonFileName) {
        this.jsonFileName = jsonFileName;
    }
}

