/*
 * Decompiled with CFR 0.152.
 */
package com.aote.sql;

import java.io.Reader;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.json.JSONObject;

public class AliasTransformer
extends AliasedTupleSubsetResultTransformer {
    public static final AliasTransformer INSTANCE = new AliasTransformer();

    private AliasTransformer() {
    }

    public Object transformTuple(Object[] tuple, String[] aliases) {
        SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(tuple.length);
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (alias == null) continue;
            Object value = tuple[i];
            if (value == null) {
                value = JSONObject.NULL;
            } else if (value instanceof Date) {
                value = SIMPLE_DATE_FORMAT.format(value);
            } else if (value instanceof Clob) {
                value = AliasTransformer.getClobString((Clob)value);
            }
            result.put(alias.toLowerCase(), value);
        }
        return result;
    }

    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public static String getClobString(Clob c) {
        try {
            Reader reader = c.getCharacterStream();
            if (reader == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            char[] charArr = new char[4096];
            int i = reader.read(charArr);
            while (i > 0) {
                sb.append(charArr, 0, i);
                i = reader.read(charArr);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

