package com.aote.util;

import com.aote.util.ResourceHelper;
import com.af.expression.Delegate;
import com.af.expression.Program;
import com.af.func.Runner;

import java.io.InputStream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import java.util.function.Function;

public class ExpressionHelper {

	/**
	 * 指定语言，运行带参数的表达式
	 * @param source: 源程序流，对于func语言，是二进制流，expression语言，是字符串流
	 * @param params: 参数
	 * @param language: 语言，空代表expression语言，“func”代表func语言。
	 * @param process: 与处理器，用于对expression对源码进行预处理，比如sql语句会添加前缀‘$‘等。
	 */
	public static Object run(InputStream source, Map<String, Object> params, String language, Function<String, String> process) throws Exception {
		// 如果是expression，从流中读取字符串，调用expression语言的执行过程
		if (language == null) {
			String str = ResourceHelper.getString(source);
			// 处理回车换行
			str = str.replace("\r\n", "\n");
			// 执行预处理过程
			str = process.apply(str);

			return run(str, params);
		} else if(language.equals("func")) {
			// 执行func语言的处理过程
			Object result = Runner.run(source, params);
			return result;
		} else {
			throw new RuntimeException("不认识对业务逻辑语言：" + language);
		}
	}

	/**
	 * 带参运行表达式
	 * @param source: 表达式源码
	 * @param params: 表达式参数
	 */
	public static Object run(String source, Map<String, Object> params) {
		Delegate delegate = getDelegate(source);
		return delegate.invoke(params);
	}
	public static Object run(Delegate delegate, Map<String, Object> params) {
		return delegate.invoke(params);
	}

	public static Delegate getDelegate(String source) {
		// 如果有save声明，设置JSON对象支持属性不存在条件
		List<String> enveronments = new ArrayList<>();
		source = getEnveronments(source, enveronments);

		Program prog = new Program(source);
		// 解析
		Delegate delegate = prog.parse();
		if (enveronments.contains("save")) {
			delegate.canJsonPropertyChoise = true;
		}
		return delegate;
	}

	// 从source中获取环境配置，返回读掉环境配置后的源程序
	private static String getEnveronments(String source, List<String> result) {
		// 环境配置以#开始，每种配置用“,”隔开
		if (!source.startsWith("#")) {
			return source;
		}

		// 读取一行数据, 包括所有配置
		int pos = source.indexOf("\n");
		String config = source.substring(1, pos);
		Collections.addAll(result, config.split(","));

		source = source.substring(pos + 1);
		return source;
	}
}
