package com.aote.test;

import java.net.URLEncoder;

import com.aote.util.other.RestTools;
import junit.framework.TestCase;

public class TestRoot extends TestCase {
	/**
	 * 调用sql查询
	 * @param name sql名称
	 * @param param sql参数
	 * @param url 发送到的应用名，比如AndroidRest等
	 * return sql返回值
	 */
	protected String sql(String name, String param, String url) {
		String path="/" + url + "/rs/sql/"+ URLEncoder.encode(name).replace("+", "%20");
		RestTools rest = new RestTools();
		String result = RestTools.post(path, param);
		return result;
	}

	/**
	 * 调用sql查询
	 * @param name sql名称
	 * @param param sql参数
	 * return sql返回值
	 */
	protected String sql(String name, String param) {
		String path="/rs/sql/"+ URLEncoder.encode(name).replace("+", "%20");
		RestTools rest = new RestTools();
		String result = RestTools.post(path, param);
		return result;
	}

	/**
	 * 调用path查询
	 * @param name path名称
	 * @param param path参数
	 * @param url 发送到的应用名，比如AndroidRest等
	 * return path返回值
	 */
	protected String path(String name, String param, String url) {
		String path="/" + url + "/rs/path/"+ URLEncoder.encode(name).replace("+", "%20");
		RestTools rest = new RestTools();
		String result = RestTools.post(path, param);
		return result;
	}

	/**
	 * 调用path查询
	 * @param name path名称
	 * @param param path参数
	 * return path返回值
	 */
	protected String path(String name, String param) {
		String path="/rs/path/"+ URLEncoder.encode(name).replace("+", "%20");
		RestTools rest = new RestTools();
		String result = RestTools.post(path, param);
		return result;
	}

	/**
	 * 调用业务逻辑
	 * @param name 业务逻辑名称
	 * @param param 业务逻辑参数
	 * @param url 发往的应用名, 比如AndroidRest等
	 * return 业务逻辑返回值
	 */
	protected String logic(String name, String param, String url) {
		String path="/" + url + "/rs/logic/"+ URLEncoder.encode(name).replace("+", "%20");
		RestTools rest = new RestTools();
		String result = RestTools.post(path, param);
		return result;
	}

	/**
	 * 调用业务逻辑
	 * @param name 业务逻辑名称
	 * @param param 业务逻辑参数
	 * return 业务逻辑返回值
	 */
	protected String logic(String name, String param) {
		String path="/rs/logic/"+ URLEncoder.encode(name).replace("+", "%20");
		RestTools rest = new RestTools();
		String result = RestTools.post(path, param);
		return result;
	}
}
